/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.adapters;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.APIModels.Part;
import io.intercom.android.sdk.models.APIModels.Participant;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.TimeUtils;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;

public class BlockAdapter
extends ArrayAdapter<Part> {
    private static final int USER_MESSAGE = 0;
    private static final int ADMIN_MESSAGE = 1;
    private static final int LOADING_TYPE = 2;
    private static final int ANNOUNCEMENT_TYPE = 3;
    private static final int SENDING = 4;
    private static final int SENDING_FAILURE = 5;
    private static final int POWERED_BY = 6;
    private static final int WELCOME = 7;
    private static final int ALT_USER_MESSAGE = 8;
    private static final int MAX_TYPE = 9;

    public BlockAdapter(Context context, int layoutResourceId, List<Part> conversationParts) {
        super(context, layoutResourceId, conversationParts);
    }

    @TargetApi(value=11)
    public View getBlockView(int position, View row, ViewGroup parent) {
        ConversationHolder holder;
        int type = this.getItemViewType(position);
        Part conversationPart = (Part)this.getItem(position);
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        boolean displayTimeStamp = true;
        if (type == 2) {
            return inflater.inflate((XmlPullParser)this.getContext().getResources().getLayout(R.layout.intercomsdk_row_loading_fullscreen), parent, false);
        }
        if (type == 6) {
            return inflater.inflate((XmlPullParser)this.getContext().getResources().getLayout(R.layout.intercomsdk_row_poweredby), parent, false);
        }
        if (row == null || !(row.getTag() instanceof ConversationHolder)) {
            row = type == 1 || type == 8 ? inflater.inflate((XmlPullParser)this.getContext().getResources().getLayout(R.layout.intercomsdk_row_admin_part), parent, false) : (type == 3 ? inflater.inflate((XmlPullParser)this.getContext().getResources().getLayout(R.layout.intercomsdk_row_big_announcement), parent, false) : (type == 7 ? inflater.inflate((XmlPullParser)this.getContext().getResources().getLayout(R.layout.intercomsdk_row_welcome), parent, false) : inflater.inflate(R.layout.intercomsdk_row_user_part, parent, false)));
            holder = new ConversationHolder();
            holder.time = (TextView)row.findViewById(R.id.rowTime);
            holder.networkAvatar = (ImageView)row.findViewById(R.id.avatarView);
            holder.cellLayout = (LinearLayout)row.findViewById(R.id.cellLayout);
            holder.blocks = conversationPart.getLayout();
            if (holder.blocks.getParent() != null) {
                ((LinearLayout)holder.blocks.getParent()).removeView((View)holder.blocks);
            }
            holder.cellLayout.addView((View)holder.blocks, 0);
            row.setFocusable(false);
            row.setTag((Object)holder);
        } else {
            holder = (ConversationHolder)row.getTag();
        }
        if (type == 7 || type == 3) {
            displayTimeStamp = false;
        }
        holder.cellLayout.setVisibility(0);
        holder.blocks = conversationPart.getLayout();
        if (holder.blocks.getParent() != null) {
            ((LinearLayout)holder.blocks.getParent()).removeView((View)holder.blocks);
        }
        if (holder.cellLayout.getChildCount() > 0) {
            holder.cellLayout.removeAllViews();
        }
        holder.cellLayout.addView((View)holder.blocks, 0);
        if (holder.time != null) {
            if (displayTimeStamp) {
                holder.time.setVisibility(0);
                if (type == 4 || type == 5) {
                    ((ViewGroup)row).setDescendantFocusability(393216);
                    holder.time.setText((CharSequence)conversationPart.getFooter());
                    holder.blocks.setAlpha(0.5f);
                } else {
                    ((ViewGroup)row).setDescendantFocusability(262144);
                    holder.time.setText((CharSequence)new TimeUtils().getFormattedTime(conversationPart.getCreatedAt(), true));
                    holder.blocks.setAlpha(1.0f);
                }
            } else {
                holder.time.setVisibility(8);
            }
        }
        Participant user = conversationPart.getParticipant();
        if ((conversationPart.getParticipant().getType().equals("admin") || type == 8) && !conversationPart.getMessageStyle().equals("intercom_welcome_message")) {
            holder.networkAvatar.setTag((Object)position);
            ImageView networkImageView = holder.networkAvatar;
            AvatarUtils.createAvatar(user.getAvatar(), networkImageView, this.getContext());
        } else {
            int pLeft = holder.blocks.getPaddingLeft();
            int pRight = holder.blocks.getPaddingRight();
            int pTop = holder.blocks.getPaddingTop();
            int pBottom = holder.blocks.getPaddingBottom();
            Drawable bg = holder.blocks.getBackground();
            PorterDuffColorFilter filter = new PorterDuffColorFilter(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()), PorterDuff.Mode.MULTIPLY);
            bg.setColorFilter((ColorFilter)filter);
            BackgroundUtils.setBackground((View)holder.blocks, bg);
            holder.blocks.setPadding(pLeft, pTop, pRight, pBottom);
        }
        return row;
    }

    public View getView(int position, View row, ViewGroup parent) {
        return this.getBlockView(position, row, parent);
    }

    public int getViewTypeCount() {
        return 9;
    }

    public int getItemViewType(int position) {
        int type = 0;
        Part conversationPart = (Part)this.getItem(position);
        if ("LoadingCell".equals(conversationPart.getMessageStyle())) {
            return 2;
        }
        if ("intercom_failed_message_style".equals(conversationPart.getMessageStyle())) {
            return 5;
        }
        if ("intercom_sending_message_style".equals(conversationPart.getMessageStyle())) {
            return 4;
        }
        if ("intercom_powered_by".equals(conversationPart.getMessageStyle())) {
            return 6;
        }
        if ("intercom_welcome_message".equals(conversationPart.getMessageStyle())) {
            return 7;
        }
        Participant user = conversationPart.getParticipant();
        if ("admin".equals(user.getType())) {
            type = "announcement".equals(conversationPart.getMessageStyle()) || "small-announcement".equals(conversationPart.getMessageStyle()) ? 3 : 1;
        }
        return type;
    }

    public boolean isEnabled(int position) {
        int type = this.getItemViewType(position);
        return type == 5 || type == 6;
    }

    static class ConversationHolder {
        TextView time;
        ImageView networkAvatar;
        LinearLayout cellLayout;
        LinearLayout blocks;

        ConversationHolder() {
        }
    }
}

