/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import io.intercom.android.sdk.logger.Logger;
import java.util.UUID;

public class DeviceUtils {
    public static String generateDeviceId(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_DATA", 0);
        String uuid = prefs.getString("DeviceId", "");
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            TelephonyManager telephonyService = (TelephonyManager)context.getSystemService("phone");
            if (DeviceUtils.checkPermission("android.permission.READ_PHONE_STATE", context)) {
                try {
                    uuid = telephonyService.getDeviceId();
                    Logger.INTERNAL(uuid, "UDID");
                }
                catch (NullPointerException e) {
                    if (DeviceUtils.checkPermission("android.permission.ACCESS_WIFI_STATE", context)) {
                        uuid = DeviceUtils.generateMacId(context);
                    }
                }
            } else if (DeviceUtils.checkPermission("android.permission.ACCESS_WIFI_STATE", context)) {
                uuid = DeviceUtils.generateMacId(context);
            }
            if (TextUtils.isEmpty((CharSequence)uuid)) {
                uuid = DeviceUtils.getAndroidId(context);
            }
            if (TextUtils.isEmpty((CharSequence)uuid)) {
                uuid = UUID.randomUUID().toString();
            }
            prefs.edit().putString("DeviceId", uuid).apply();
            return uuid;
        }
        return uuid;
    }

    private static String generateMacId(Context context) {
        WifiManager wifiMan = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInf = wifiMan.getConnectionInfo();
        String macAddr = wifiInf.getMacAddress();
        String androidId = DeviceUtils.getAndroidId(context);
        UUID deviceUuid = new UUID(androidId.hashCode(), macAddr.hashCode());
        return deviceUuid.toString();
    }

    private static boolean checkPermission(String permissionType, Context context) {
        int res = context.checkCallingOrSelfPermission(permissionType);
        return res == 0;
    }

    private static String getAndroidId(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return androidId.equalsIgnoreCase("9774d56d682e549c") ? null : androidId;
    }

    public static boolean isMessagingSDKSupported(int androidOsVersion) {
        return androidOsVersion > 14;
    }
}

