/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.ui.common;

import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import androidx.activity.result.contract.ActivityResultContract;
import io.intercom.android.sdk.ui.common.MediaPickerButtonKt;
import io.intercom.android.sdk.ui.common.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000e\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u001b\u0010\u0017\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\rH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/intercom/android/sdk/ui/common/IntercomMediaPicker;", "Landroidx/activity/result/contract/ActivityResultContract;", "", "", "Landroid/net/Uri;", "mediaType", "Lio/intercom/android/sdk/ui/common/MediaType;", "trustedFileExtensions", "", "maxSelectionCount", "", "(Lio/intercom/android/sdk/ui/common/MediaType;Ljava/util/Set;I)V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "getAllMimeTypes", "", "()[Ljava/lang/String;", "getDocumentMimeTypes", "getImageMimeTypes", "getIntent", "getNativePickerIntent", "supportedTypes", "([Ljava/lang/String;)Landroid/content/Intent;", "getPhotoPickerIntent", "getVideoMimeTypes", "parseResult", "resultCode", "intent", "getClipDataUris", "intercom-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nMediaPickerButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaPickerButton.kt\nio/intercom/android/sdk/ui/common/IntercomMediaPicker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n3829#2:237\n4344#2,2:238\n3829#2:242\n4344#2,2:243\n3829#2:247\n4344#2,2:248\n37#3,2:240\n37#3,2:245\n37#3,2:250\n37#3,2:265\n1611#4,9:252\n1863#4:261\n1864#4:263\n1620#4:264\n1#5:262\n*S KotlinDebug\n*F\n+ 1 MediaPickerButton.kt\nio/intercom/android/sdk/ui/common/IntercomMediaPicker\n*L\n161#1:237\n161#1:238,2\n164#1:242\n164#1:243,2\n167#1:247\n167#1:248,2\n161#1:240,2\n164#1:245,2\n168#1:250,2\n172#1:265,2\n170#1:252,9\n170#1:261\n170#1:263\n170#1:264\n170#1:262\n*E\n"})
final class IntercomMediaPicker
extends ActivityResultContract<String, List<? extends Uri>> {
    @NotNull
    private final MediaType mediaType;
    @NotNull
    private final Set<String> trustedFileExtensions;
    private final int maxSelectionCount;

    public IntercomMediaPicker(@NotNull MediaType mediaType, @NotNull Set<String> trustedFileExtensions, int maxSelectionCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        Intrinsics.checkNotNullParameter(trustedFileExtensions, (String)"trustedFileExtensions");
        this.mediaType = mediaType;
        this.trustedFileExtensions = trustedFileExtensions;
        this.maxSelectionCount = maxSelectionCount;
    }

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.getIntent(input);
    }

    @NotNull
    public List<Uri> parseResult(int resultCode, @Nullable Intent intent) {
        Object object;
        Intent it = object = intent;
        boolean bl = false;
        Intent intent2 = resultCode == -1 ? object : null;
        return intent2 != null && (object = this.getClipDataUris(intent2)) != null ? object : CollectionsKt.emptyList();
    }

    private final Intent getIntent(String input) {
        Intent intent;
        switch (WhenMappings.$EnumSwitchMapping$0[this.mediaType.ordinal()]) {
            case 1: {
                Intent intent2 = new Intent("android.intent.action.GET_CONTENT").addCategory("android.intent.category.OPENABLE").putExtra("android.intent.extra.MIME_TYPES", this.getAllMimeTypes()).setType(input).putExtra("android.intent.extra.ALLOW_MULTIPLE", this.maxSelectionCount > 1);
                Intrinsics.checkNotNull((Object)intent2);
                intent = intent2;
                break;
            }
            case 2: {
                intent = this.getNativePickerIntent(this.getDocumentMimeTypes());
                break;
            }
            case 3: {
                if (MediaPickerButtonKt.isPhotoPickerAvailable()) {
                    intent = this.getPhotoPickerIntent((String[])ArraysKt.plus((Object[])this.getImageMimeTypes(), (Object[])this.getVideoMimeTypes()));
                    break;
                }
                intent = this.getNativePickerIntent((String[])ArraysKt.plus((Object[])this.getImageMimeTypes(), (Object[])this.getVideoMimeTypes()));
                break;
            }
            case 4: {
                if (MediaPickerButtonKt.isPhotoPickerAvailable()) {
                    intent = this.getPhotoPickerIntent(this.getImageMimeTypes());
                    break;
                }
                intent = this.getNativePickerIntent(this.getImageMimeTypes());
                break;
            }
            case 5: {
                if (MediaPickerButtonKt.isPhotoPickerAvailable()) {
                    intent = this.getPhotoPickerIntent(this.getVideoMimeTypes());
                    break;
                }
                intent = this.getNativePickerIntent(this.getVideoMimeTypes());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return intent;
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getVideoMimeTypes() {
        void $this$filterTo$iv$iv;
        String[] $this$filter$iv = this.getAllMimeTypes();
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"video", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getImageMimeTypes() {
        void $this$filterTo$iv$iv;
        String[] $this$filter$iv = this.getAllMimeTypes();
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"image", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getDocumentMimeTypes() {
        void $this$filterTo$iv$iv;
        String[] $this$filter$iv = this.getAllMimeTypes();
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"application", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"text", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getAllMimeTypes() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.trustedFileExtensions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (MimeTypeMap.getSingleton().getMimeTypeFromExtension(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private final Intent getPhotoPickerIntent(String[] supportedTypes) {
        Intent intent;
        Intent $this$getPhotoPickerIntent_u24lambda_u246 = intent = new Intent("android.provider.action.PICK_IMAGES");
        boolean bl = false;
        $this$getPhotoPickerIntent_u24lambda_u246.putExtra("android.intent.extra.MIME_TYPES", supportedTypes);
        if (this.maxSelectionCount > 1) {
            if (!(this.maxSelectionCount <= MediaStore.getPickImagesMaxLimit())) {
                boolean bl2 = false;
                String string = "Max items must be less or equals MediaStore.getPickImagesMaxLimit()";
                throw new IllegalArgumentException(string.toString());
            }
            $this$getPhotoPickerIntent_u24lambda_u246.putExtra("android.provider.extra.PICK_IMAGES_MAX", this.maxSelectionCount);
        }
        return intent;
    }

    private final Intent getNativePickerIntent(String[] supportedTypes) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT").addCategory("android.intent.category.OPENABLE").setType((String)ArraysKt.first((Object[])supportedTypes)).putExtra("android.intent.extra.MIME_TYPES", supportedTypes).addFlags(1).putExtra("android.intent.extra.ALLOW_MULTIPLE", this.maxSelectionCount > 1);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"putExtra(...)");
        return intent;
    }

    private final List<Uri> getClipDataUris(Intent $this$getClipDataUris) {
        LinkedHashSet<Uri> resultSet = new LinkedHashSet<Uri>();
        Uri uri = $this$getClipDataUris.getData();
        if (uri != null) {
            Uri data = uri;
            boolean bl = false;
            resultSet.add(data);
        }
        ClipData clipData = $this$getClipDataUris.getClipData();
        if (clipData == null && resultSet.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (clipData != null) {
            int n = clipData.getItemCount();
            for (int i = 0; i < n; ++i) {
                Uri uri2 = clipData.getItemAt(i).getUri();
                if (uri2 == null) continue;
                resultSet.add(uri2);
            }
        }
        return new ArrayList(resultSet);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MediaType.values().length];
            try {
                nArray[MediaType.All.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaType.DocumentOnly.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaType.ImageAndVideo.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaType.ImageOnly.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaType.VideOnly.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

