/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.lightcompressor.video;

import android.media.MediaCodec;
import android.media.MediaFormat;
import io.intercom.android.sdk.lightcompressor.video.Mdat;
import io.intercom.android.sdk.lightcompressor.video.Mp4Movie;
import io.intercom.android.sdk.lightcompressor.video.Sample;
import io.intercom.android.sdk.lightcompressor.video.Track;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part12.DataEntryUrlBox;
import org.mp4parser.boxes.iso14496.part12.DataInformationBox;
import org.mp4parser.boxes.iso14496.part12.DataReferenceBox;
import org.mp4parser.boxes.iso14496.part12.FileTypeBox;
import org.mp4parser.boxes.iso14496.part12.HandlerBox;
import org.mp4parser.boxes.iso14496.part12.HintMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MediaBox;
import org.mp4parser.boxes.iso14496.part12.MediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MediaInformationBox;
import org.mp4parser.boxes.iso14496.part12.MovieBox;
import org.mp4parser.boxes.iso14496.part12.MovieHeaderBox;
import org.mp4parser.boxes.iso14496.part12.NullMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.SampleSizeBox;
import org.mp4parser.boxes.iso14496.part12.SampleTableBox;
import org.mp4parser.boxes.iso14496.part12.SampleToChunkBox;
import org.mp4parser.boxes.iso14496.part12.SoundMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.StaticChunkOffsetBox;
import org.mp4parser.boxes.iso14496.part12.SubtitleMediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.SyncSampleBox;
import org.mp4parser.boxes.iso14496.part12.TimeToSampleBox;
import org.mp4parser.boxes.iso14496.part12.TrackBox;
import org.mp4parser.boxes.iso14496.part12.TrackHeaderBox;
import org.mp4parser.boxes.iso14496.part12.VideoMediaHeaderBox;
import org.mp4parser.support.Matrix;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0002J&\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0010J\u0016\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\u0010J\u0006\u0010%\u001a\u00020\u001aJ\b\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0002J\u0010\u0010+\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0007H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0007H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00101\u001a\u00020\u0013H\u0002J\u0018\u00104\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0002J\u0018\u00108\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0002J\u0018\u00109\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0002J\u0018\u0010:\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0002J\u0018\u0010;\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lio/intercom/android/sdk/lightcompressor/video/MP4Builder;", "", "<init>", "()V", "mdat", "Lio/intercom/android/sdk/lightcompressor/video/Mdat;", "currentMp4Movie", "Lio/intercom/android/sdk/lightcompressor/video/Mp4Movie;", "fos", "Ljava/io/FileOutputStream;", "fc", "Ljava/nio/channels/FileChannel;", "dataOffset", "", "wroteSinceLastMdat", "writeNewMdat", "", "track2SampleSizes", "Ljava/util/HashMap;", "Lio/intercom/android/sdk/lightcompressor/video/Track;", "", "sizeBuffer", "Ljava/nio/ByteBuffer;", "createMovie", "mp4Movie", "flushCurrentMdat", "", "writeSampleData", "trackIndex", "", "byteBuf", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "isAudio", "addTrack", "mediaFormat", "Landroid/media/MediaFormat;", "finishMovie", "createFileTypeBox", "Lorg/mp4parser/boxes/iso14496/part12/FileTypeBox;", "gcd", "a", "b", "getTimescale", "createMovieBox", "Lorg/mp4parser/boxes/iso14496/part12/MovieBox;", "movie", "createTrackBox", "Lorg/mp4parser/boxes/iso14496/part12/TrackBox;", "track", "createStbl", "Lorg/mp4parser/Box;", "createStsd", "stbl", "Lorg/mp4parser/boxes/iso14496/part12/SampleTableBox;", "createStts", "createStss", "createStsc", "createStsz", "createStco", "intercom-sdk-lightcompressor_release"})
public final class MP4Builder {
    private Mdat mdat;
    private Mp4Movie currentMp4Movie;
    private FileOutputStream fos;
    private FileChannel fc;
    private long dataOffset;
    private long wroteSinceLastMdat;
    private boolean writeNewMdat = true;
    @NotNull
    private final HashMap<Track, long[]> track2SampleSizes = new HashMap();
    private ByteBuffer sizeBuffer;

    @NotNull
    public final MP4Builder createMovie(@NotNull Mp4Movie mp4Movie) throws Exception {
        Intrinsics.checkNotNullParameter((Object)mp4Movie, (String)"mp4Movie");
        this.currentMp4Movie = mp4Movie;
        this.fos = new FileOutputStream(mp4Movie.getCacheFile());
        FileOutputStream fileOutputStream = this.fos;
        if (fileOutputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fos");
            fileOutputStream = null;
        }
        this.fc = fileOutputStream.getChannel();
        FileTypeBox fileTypeBox = this.createFileTypeBox();
        FileChannel fileChannel = this.fc;
        if (fileChannel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            fileChannel = null;
        }
        fileTypeBox.getBox((WritableByteChannel)fileChannel);
        this.dataOffset += fileTypeBox.getSize();
        this.wroteSinceLastMdat = this.dataOffset;
        this.mdat = new Mdat();
        this.sizeBuffer = ByteBuffer.allocateDirect(4);
        return this;
    }

    private final void flushCurrentMdat() throws Exception {
        FileChannel fileChannel;
        Mdat mdat;
        FileChannel fileChannel2 = this.fc;
        if (fileChannel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            fileChannel2 = null;
        }
        long oldPosition = fileChannel2.position();
        FileChannel fileChannel3 = this.fc;
        if (fileChannel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            fileChannel3 = null;
        }
        if ((mdat = this.mdat) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            mdat = null;
        }
        fileChannel3.position(mdat.getOffset());
        Mdat mdat2 = this.mdat;
        if (mdat2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            mdat2 = null;
        }
        if ((fileChannel = this.fc) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            fileChannel = null;
        }
        mdat2.getBox(fileChannel);
        FileChannel fileChannel4 = this.fc;
        if (fileChannel4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            fileChannel4 = null;
        }
        fileChannel4.position(oldPosition);
        Mdat mdat3 = this.mdat;
        if (mdat3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            mdat3 = null;
        }
        mdat3.setDataOffset(0L);
        Mdat mdat4 = this.mdat;
        if (mdat4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            mdat4 = null;
        }
        mdat4.setContentSize(0L);
        FileOutputStream fileOutputStream = this.fos;
        if (fileOutputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fos");
            fileOutputStream = null;
        }
        fileOutputStream.flush();
    }

    public final void writeSampleData(int trackIndex, @NotNull ByteBuffer byteBuf, @NotNull MediaCodec.BufferInfo bufferInfo, boolean isAudio) throws Exception {
        FileChannel fileChannel;
        Object object;
        Mp4Movie mp4Movie;
        Mdat mdat;
        Mdat mdat2;
        Intrinsics.checkNotNullParameter((Object)byteBuf, (String)"byteBuf");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        if (this.writeNewMdat) {
            Mdat mdat3;
            Mdat mdat4 = this.mdat;
            if (mdat4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
                mdat4 = null;
            }
            Mdat $this$writeSampleData_u24lambda_u240 = mdat3 = mdat4;
            boolean bl = false;
            $this$writeSampleData_u24lambda_u240.setContentSize(0L);
            FileChannel fileChannel2 = this.fc;
            if (fileChannel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
                fileChannel2 = null;
            }
            $this$writeSampleData_u24lambda_u240.getBox(fileChannel2);
            $this$writeSampleData_u24lambda_u240.setDataOffset(this.dataOffset);
            this.dataOffset += (long)16;
            this.wroteSinceLastMdat += (long)16;
            this.writeNewMdat = false;
        }
        if ((mdat2 = this.mdat) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            mdat2 = null;
        }
        if ((mdat = this.mdat) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            mdat = null;
        }
        mdat2.setContentSize(mdat.getContentSize() + (long)bufferInfo.size);
        this.wroteSinceLastMdat += (long)bufferInfo.size;
        boolean flush = false;
        if (this.wroteSinceLastMdat >= 32768L) {
            this.flushCurrentMdat();
            this.writeNewMdat = true;
            flush = true;
            this.wroteSinceLastMdat = 0L;
        }
        if ((mp4Movie = this.currentMp4Movie) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentMp4Movie");
            mp4Movie = null;
        }
        mp4Movie.addSample(trackIndex, this.dataOffset, bufferInfo);
        if (!isAudio) {
            ByteBuffer byteBuffer;
            byteBuf.position(bufferInfo.offset + 4);
            byteBuf.limit(bufferInfo.offset + bufferInfo.size);
            ByteBuffer byteBuffer2 = this.sizeBuffer;
            if (byteBuffer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sizeBuffer");
                byteBuffer2 = null;
            }
            byteBuffer2.position(0);
            ByteBuffer byteBuffer3 = this.sizeBuffer;
            if (byteBuffer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sizeBuffer");
                byteBuffer3 = null;
            }
            byteBuffer3.putInt(bufferInfo.size - 4);
            ByteBuffer byteBuffer4 = this.sizeBuffer;
            if (byteBuffer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sizeBuffer");
                byteBuffer4 = null;
            }
            byteBuffer4.position(0);
            FileChannel fileChannel3 = this.fc;
            if (fileChannel3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
                fileChannel3 = null;
            }
            if ((byteBuffer = this.sizeBuffer) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sizeBuffer");
                byteBuffer = null;
            }
            object = fileChannel3.write(byteBuffer);
        } else {
            byteBuf.position(bufferInfo.offset + 0);
            object = byteBuf.limit(bufferInfo.offset + bufferInfo.size);
        }
        if ((fileChannel = this.fc) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            fileChannel = null;
        }
        fileChannel.write(byteBuf);
        this.dataOffset += (long)bufferInfo.size;
        if (flush) {
            FileOutputStream fileOutputStream = this.fos;
            if (fileOutputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fos");
                fileOutputStream = null;
            }
            fileOutputStream.flush();
        }
    }

    public final int addTrack(@NotNull MediaFormat mediaFormat, boolean isAudio) {
        Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
        Mp4Movie mp4Movie = this.currentMp4Movie;
        if (mp4Movie == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentMp4Movie");
            mp4Movie = null;
        }
        return mp4Movie.addTrack(mediaFormat, isAudio);
    }

    public final void finishMovie() throws Exception {
        Mp4Movie mp4Movie;
        Mdat mdat = this.mdat;
        if (mdat == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mdat");
            mdat = null;
        }
        if (mdat.getContentSize() != 0L) {
            this.flushCurrentMdat();
        }
        if ((mp4Movie = this.currentMp4Movie) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentMp4Movie");
            mp4Movie = null;
        }
        Iterator<Track> iterator = mp4Movie.getTracks().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Track> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Track track;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            List samples = track.getSamples();
            long[] sizes = new long[samples.size()];
            int n = sizes.length;
            for (int i = 0; i < n; ++i) {
                sizes[i] = ((Sample)samples.get(i)).getSize();
            }
            ((Map)this.track2SampleSizes).put(track, sizes);
        }
        Mp4Movie mp4Movie2 = this.currentMp4Movie;
        if (mp4Movie2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentMp4Movie");
            mp4Movie2 = null;
        }
        Box moov = (Box)this.createMovieBox(mp4Movie2);
        FileChannel fileChannel = this.fc;
        if (fileChannel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            fileChannel = null;
        }
        moov.getBox((WritableByteChannel)fileChannel);
        FileOutputStream fileOutputStream = this.fos;
        if (fileOutputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fos");
            fileOutputStream = null;
        }
        fileOutputStream.flush();
        FileChannel fileChannel2 = this.fc;
        if (fileChannel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fc");
            fileChannel2 = null;
        }
        fileChannel2.close();
        FileOutputStream fileOutputStream2 = this.fos;
        if (fileOutputStream2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fos");
            fileOutputStream2 = null;
        }
        fileOutputStream2.close();
    }

    private final FileTypeBox createFileTypeBox() {
        Object[] objectArray = new String[]{"isom", "iso2", "mp41"};
        List minorBrands = CollectionsKt.listOf((Object[])objectArray);
        return new FileTypeBox("mp42", 0L, minorBrands);
    }

    private final long gcd(long a, long b) {
        return b == 0L ? a : this.gcd(b, a % b);
    }

    private final long getTimescale(Mp4Movie mp4Movie) {
        long timescale = 0L;
        if (!((Collection)mp4Movie.getTracks()).isEmpty()) {
            timescale = mp4Movie.getTracks().iterator().next().getTimeScale();
        }
        Iterator<Track> iterator = mp4Movie.getTracks().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Track> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Track track;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            timescale = this.gcd(track.getTimeScale(), timescale);
        }
        return timescale;
    }

    private final MovieBox createMovieBox(Mp4Movie movie) {
        Track track;
        MovieHeaderBox mvhd;
        MovieHeaderBox movieHeaderBox;
        MovieBox movieBox = new MovieBox();
        MovieHeaderBox $this$createMovieBox_u24lambda_u241 = movieHeaderBox = (mvhd = new MovieHeaderBox());
        boolean bl = false;
        $this$createMovieBox_u24lambda_u241.setCreationTime(new Date());
        $this$createMovieBox_u24lambda_u241.setModificationTime(new Date());
        $this$createMovieBox_u24lambda_u241.setMatrix(Matrix.ROTATE_0);
        long movieTimeScale = this.getTimescale(movie);
        long duration = 0L;
        Iterator<Track> iterator = movie.getTracks().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Track> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            long tracksDuration = track.getDuration() * movieTimeScale / (long)track.getTimeScale();
            if (tracksDuration <= duration) continue;
            duration = tracksDuration;
        }
        mvhd.setDuration(duration);
        mvhd.setTimescale(movieTimeScale);
        mvhd.setNextTrackId((long)(movie.getTracks().size() + 1));
        movieBox.addBox((Box)mvhd);
        Iterator<Track> iterator3 = movie.getTracks().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            movieBox.addBox((Box)this.createTrackBox(track, movie));
        }
        return movieBox;
    }

    private final TrackBox createTrackBox(Track track, Mp4Movie movie) {
        MediaHeaderBox mdhd;
        TrackHeaderBox tkhd;
        TrackHeaderBox trackHeaderBox;
        TrackBox trackBox = new TrackBox();
        TrackHeaderBox $this$createTrackBox_u24lambda_u242 = trackHeaderBox = (tkhd = new TrackHeaderBox());
        boolean bl = false;
        $this$createTrackBox_u24lambda_u242.setEnabled(true);
        $this$createTrackBox_u24lambda_u242.setInPreview(true);
        $this$createTrackBox_u24lambda_u242.setInMovie(true);
        $this$createTrackBox_u24lambda_u242.setMatrix(track.isAudio() ? Matrix.ROTATE_0 : movie.getMatrix());
        $this$createTrackBox_u24lambda_u242.setAlternateGroup(0);
        $this$createTrackBox_u24lambda_u242.setCreationTime(track.getCreationTime());
        $this$createTrackBox_u24lambda_u242.setDuration(track.getDuration() * this.getTimescale(movie) / (long)track.getTimeScale());
        $this$createTrackBox_u24lambda_u242.setHeight((double)track.getHeight());
        $this$createTrackBox_u24lambda_u242.setWidth((double)track.getWidth());
        $this$createTrackBox_u24lambda_u242.setLayer(0);
        $this$createTrackBox_u24lambda_u242.setModificationTime(new Date());
        $this$createTrackBox_u24lambda_u242.setTrackId(track.getTrackId() + 1L);
        $this$createTrackBox_u24lambda_u242.setVolume(track.getVolume());
        trackBox.addBox((Box)tkhd);
        MediaBox mdia = new MediaBox();
        trackBox.addBox((Box)mdia);
        MediaHeaderBox $this$createTrackBox_u24lambda_u243 = bl = (mdhd = new MediaHeaderBox());
        boolean bl2 = false;
        $this$createTrackBox_u24lambda_u243.setCreationTime(track.getCreationTime());
        $this$createTrackBox_u24lambda_u243.setDuration(track.getDuration());
        $this$createTrackBox_u24lambda_u243.setTimescale((long)track.getTimeScale());
        $this$createTrackBox_u24lambda_u243.setLanguage("eng");
        mdia.addBox((Box)mdhd);
        HandlerBox hdlr = new HandlerBox();
        MediaHeaderBox $this$createTrackBox_u24lambda_u244 = $this$createTrackBox_u24lambda_u243 = hdlr;
        boolean bl3 = false;
        $this$createTrackBox_u24lambda_u244.setName(track.isAudio() ? "SoundHandle" : "VideoHandle");
        $this$createTrackBox_u24lambda_u244.setHandlerType(track.getHandler());
        mdia.addBox((Box)hdlr);
        MediaInformationBox minf = new MediaInformationBox();
        if (Intrinsics.areEqual((Object)track.getHandler(), (Object)"vide")) {
            minf.addBox((Box)new VideoMediaHeaderBox());
        } else if (Intrinsics.areEqual((Object)track.getHandler(), (Object)"soun")) {
            minf.addBox((Box)new SoundMediaHeaderBox());
        } else if (Intrinsics.areEqual((Object)track.getHandler(), (Object)"text")) {
            minf.addBox((Box)new NullMediaHeaderBox());
        } else if (Intrinsics.areEqual((Object)track.getHandler(), (Object)"subt")) {
            minf.addBox((Box)new SubtitleMediaHeaderBox());
        } else if (Intrinsics.areEqual((Object)track.getHandler(), (Object)"hint")) {
            minf.addBox((Box)new HintMediaHeaderBox());
        } else if (Intrinsics.areEqual((Object)track.getHandler(), (Object)"sbtl")) {
            minf.addBox((Box)new NullMediaHeaderBox());
        }
        DataInformationBox dinf = new DataInformationBox();
        DataReferenceBox dref = new DataReferenceBox();
        dinf.addBox((Box)dref);
        DataEntryUrlBox url = new DataEntryUrlBox();
        url.setFlags(1);
        dref.addBox((Box)url);
        minf.addBox((Box)dinf);
        Box stbl = this.createStbl(track);
        minf.addBox(stbl);
        mdia.addBox((Box)minf);
        return trackBox;
    }

    private final Box createStbl(Track track) {
        SampleTableBox stbl = new SampleTableBox();
        this.createStsd(track, stbl);
        this.createStts(track, stbl);
        this.createStss(track, stbl);
        this.createStsc(track, stbl);
        this.createStsz(track, stbl);
        this.createStco(track, stbl);
        return (Box)stbl;
    }

    private final void createStsd(Track track, SampleTableBox stbl) {
        stbl.addBox((Box)track.getSampleDescriptionBox());
    }

    private final void createStts(Track track, SampleTableBox stbl) {
        TimeToSampleBox.Entry lastEntry = null;
        List entries = new ArrayList();
        Iterator<Long> iterator = track.getSampleDurations().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Long> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Long l = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"next(...)");
            long delta = ((Number)l).longValue();
            if (lastEntry != null && lastEntry.getDelta() == delta) {
                lastEntry.setCount(lastEntry.getCount() + 1L);
                continue;
            }
            lastEntry = new TimeToSampleBox.Entry(1L, delta);
            entries.add(lastEntry);
        }
        TimeToSampleBox stts = new TimeToSampleBox();
        stts.setEntries(entries);
        stbl.addBox((Box)stts);
    }

    private final void createStss(Track track, SampleTableBox stbl) {
        long[] syncSamples = track.getSyncSamples();
        if (syncSamples != null && !(syncSamples.length == 0)) {
            SyncSampleBox stss = new SyncSampleBox();
            stss.setSampleNumber(syncSamples);
            stbl.addBox((Box)stss);
        }
    }

    private final void createStsc(Track track, SampleTableBox stbl) {
        SampleToChunkBox stsc = new SampleToChunkBox();
        stsc.setEntries((List)new LinkedList());
        long lastOffset = 0L;
        int lastChunkNumber = 1;
        int lastSampleCount = 0;
        int previousWrittenChunkCount = -1;
        int samplesCount = track.getSamples().size();
        for (int a = 0; a < samplesCount; ++a) {
            Sample sample;
            Intrinsics.checkNotNullExpressionValue((Object)track.getSamples().get(a), (String)"get(...)");
            long offset = sample.getOffset();
            long size = sample.getSize();
            lastOffset = offset + size;
            ++lastSampleCount;
            boolean write = false;
            if (a != samplesCount - 1) {
                Sample nextSample;
                Intrinsics.checkNotNullExpressionValue((Object)track.getSamples().get(a + 1), (String)"get(...)");
                if (lastOffset != nextSample.getOffset()) {
                    write = true;
                }
            } else {
                write = true;
            }
            if (!write) continue;
            if (previousWrittenChunkCount != lastSampleCount) {
                stsc.getEntries().add(new SampleToChunkBox.Entry((long)lastChunkNumber, (long)lastSampleCount, 1L));
                previousWrittenChunkCount = lastSampleCount;
            }
            lastSampleCount = 0;
            ++lastChunkNumber;
        }
        stbl.addBox((Box)stsc);
    }

    private final void createStsz(Track track, SampleTableBox stbl) {
        SampleSizeBox stsz = new SampleSizeBox();
        stsz.setSampleSizes(this.track2SampleSizes.get(track));
        stbl.addBox((Box)stsz);
    }

    private final void createStco(Track track, SampleTableBox stbl) {
        ArrayList<Long> chunksOffsets = new ArrayList<Long>();
        long lastOffset = -1L;
        Iterator<Sample> iterator = track.getSamples().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Sample> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Sample sample;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            long offset = sample.getOffset();
            if (lastOffset != -1L && lastOffset != offset) {
                lastOffset = -1L;
            }
            if (lastOffset == -1L) {
                chunksOffsets.add(offset);
            }
            lastOffset = offset + sample.getSize();
        }
        long[] chunkOffsetsLong = new long[chunksOffsets.size()];
        int n = ((Collection)chunksOffsets).size();
        for (int a = 0; a < n; ++a) {
            Object e = chunksOffsets.get(a);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            chunkOffsetsLong[a] = ((Number)e).longValue();
        }
        StaticChunkOffsetBox stco = new StaticChunkOffsetBox();
        stco.setChunkOffsets(chunkOffsetsLong);
        stbl.addBox((Box)stco);
    }
}

