/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.fcm;

import android.content.Context;
import android.text.TextUtils;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.user.DeviceData;

public class IntercomFcmInstanceIdService
extends FirebaseInstanceIdService {
    public void onTokenRefresh() {
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();
        if (TextUtils.isEmpty((CharSequence)refreshedToken)) {
            IntercomLogger.e((String)"Intercom push registration failed. Please make sure you have added a google-services.json file");
        } else {
            this.sendTokenToIntercom(refreshedToken);
        }
    }

    private void sendTokenToIntercom(String token) {
        if (!DeviceData.hasCachedPushToken((Context)this, (String)token)) {
            Injector.get().getApi().setDeviceToken(token);
            DeviceData.cachePushToken((Context)this, (String)token);
        }
    }
}

