/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.messengercard;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.appcompat.app.AlertDialog;
import com.google.gson.Gson;
import io.intercom.android.sdk.activities.IntercomSheetActivity;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardAlertDialogBuilder;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardWebViewAction;
import io.intercom.android.sdk.metrics.MetricTracker;
import java.util.HashMap;
import java.util.Map;

class MessengerCardWebViewInterface {
    private static final String OPEN_URL = "OPEN_URL";
    private static final String OPEN_SHEET = "OPEN_SHEET";
    private static final String INPUT_TEXT = "INPUT_TEXT";
    private static final String METRIC_EVENT = "METRIC_EVENT";
    private static final String HEIGHT_CHANGE_EVENT = "HEIGHT_CHANGE_EVENT";
    private final WebView webView;
    private final View loadingView;
    private final Gson gson;
    private final int primaryColor;
    private final MetricTracker metricTracker;
    private final String conversationId;
    private final Boolean isHomescreen;
    private final Activity activity;

    MessengerCardWebViewInterface(WebView webView, View loadingView, Gson gson, @ColorInt int primaryColor, MetricTracker metricTracker, String conversationId, boolean isHomescreen, Activity activity) {
        this.webView = webView;
        this.loadingView = loadingView;
        this.gson = gson;
        this.primaryColor = primaryColor;
        this.metricTracker = metricTracker;
        this.conversationId = conversationId;
        this.isHomescreen = isHomescreen;
        this.activity = activity;
    }

    @JavascriptInterface
    public void handleAction(String actionJson) {
        final MessengerCardWebViewAction action = (MessengerCardWebViewAction)this.gson.fromJson(actionJson, MessengerCardWebViewAction.class);
        final Map<String, Object> payload = action.getPayload();
        String type = action.getType();
        if (type == null || payload == null) {
            return;
        }
        switch (type) {
            case "OPEN_URL": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        MessengerCardWebViewInterface.this.openUrl(payload, (Context)MessengerCardWebViewInterface.this.activity);
                    }
                });
                break;
            }
            case "OPEN_SHEET": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        MessengerCardWebViewInterface.this.openSheet(payload, (Context)MessengerCardWebViewInterface.this.activity);
                    }
                });
                break;
            }
            case "INPUT_TEXT": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        MessengerCardWebViewInterface.this.showTextInputDialog(payload, (Context)MessengerCardWebViewInterface.this.activity);
                    }
                });
                break;
            }
            case "HEIGHT_CHANGE_EVENT": {
                if (this.loadingView.getVisibility() != 0) break;
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        MessengerCardWebViewInterface.this.loadingView.setVisibility(8);
                        MessengerCardWebViewInterface.this.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
                    }
                });
                break;
            }
            case "METRIC_EVENT": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        Map<String, Object> actionValue = action.getPayload();
                        String eventAction = (String)actionValue.get("action");
                        String eventObject = (String)actionValue.get("object");
                        String eventPlace = (String)actionValue.get("place");
                        Map eventMetaData = null;
                        if (actionValue.get("metadata") instanceof Map) {
                            eventMetaData = (Map)actionValue.get("metadata");
                        }
                        MessengerCardWebViewInterface.this.metricTracker.messengerCardWebViewEvent(eventAction, eventObject, eventPlace, eventMetaData, MessengerCardWebViewInterface.this.isHomescreen);
                    }
                });
                break;
            }
        }
    }

    private void openUrl(Map<String, Object> payload, Context context) {
        String url = (String)payload.get("url");
        context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
    }

    private void openSheet(Map<String, Object> payload, Context context) {
        String cardUri;
        String url = (String)payload.get("url");
        Map<String, Object> params = payload.containsKey("params") ? (Map)payload.get("params") : new HashMap();
        String string2 = cardUri = params.containsKey("uri") ? params.get("uri").toString() : "";
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)cardUri)) {
            return;
        }
        Intent intent = IntercomSheetActivity.buildIntent(context, url, params, cardUri, this.conversationId);
        context.startActivity(intent);
    }

    private void showTextInputDialog(Map<String, Object> payload, Context context) {
        MessengerCardAlertDialogBuilder dialogBuilder = new MessengerCardAlertDialogBuilder(context, payload, this.primaryColor, this.webView);
        AlertDialog dialog = dialogBuilder.create();
        dialog.show();
        dialog.getWindow().setSoftInputMode(5);
        dialog.getButton(-2).setTextColor(this.primaryColor);
        dialog.getButton(-1).setTextColor(this.primaryColor);
    }
}

