/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.articles;

import io.intercom.android.sdk.articles.ArticleWebViewView;

public class ArticleWebViewPresenter {
    private final ArticleWebViewView articleWebViewView;
    private final String baseUrl;
    private final String articleId;
    private final Boolean isUserRegistered;

    public ArticleWebViewPresenter(ArticleWebViewView articleWebViewView, String baseUrl, String articleId, Boolean isUserRegistered) {
        this.articleWebViewView = articleWebViewView;
        this.baseUrl = baseUrl;
        this.articleId = articleId;
        this.isUserRegistered = isUserRegistered;
    }

    public void onUiLoad() {
        if (this.isUserRegistered.booleanValue()) {
            String url = this.baseUrl + "/articles/" + this.articleId;
            this.articleWebViewView.setCookies(this.baseUrl);
            this.articleWebViewView.loadUrl(url);
        } else {
            this.articleWebViewView.logUserNotRegisteredError();
            this.articleWebViewView.showError();
        }
    }

    public void onWebViewStartedLoading() {
        this.articleWebViewView.showLoadingState();
    }

    public void onWebViewFinishedLoading() {
        this.articleWebViewView.showContent();
    }

    public void onWebViewError() {
        this.articleWebViewView.showError();
    }

    public void articleNotFound() {
        this.articleWebViewView.showArticleNotFoundError();
    }
}

