/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.facebook.shimmer;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.intercom.com.facebook.shimmer.Shimmer;

public final class ShimmerDrawable
extends Drawable {
    private final ValueAnimator.AnimatorUpdateListener mUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            ShimmerDrawable.this.invalidateSelf();
        }
    };
    private final Paint mShimmerPaint = new Paint();
    private final Rect mDrawRect = new Rect();
    private final Matrix mShaderMatrix = new Matrix();
    @Nullable
    private ValueAnimator mValueAnimator;
    @Nullable
    private Shimmer mShimmer;

    public ShimmerDrawable() {
        this.mShimmerPaint.setAntiAlias(true);
    }

    public void setShimmer(@Nullable Shimmer shimmer) {
        this.mShimmer = shimmer;
        if (this.mShimmer != null) {
            this.mShimmerPaint.setXfermode((Xfermode)new PorterDuffXfermode(this.mShimmer.alphaShimmer ? PorterDuff.Mode.DST_IN : PorterDuff.Mode.SRC_IN));
        }
        this.updateShader();
        this.updateValueAnimator();
        this.invalidateSelf();
    }

    public void startShimmer() {
        if (this.mValueAnimator != null && !this.isShimmerStarted() && this.getCallback() != null) {
            this.mValueAnimator.start();
        }
    }

    public void stopShimmer() {
        if (this.mValueAnimator != null && this.isShimmerStarted()) {
            this.mValueAnimator.cancel();
        }
    }

    public boolean isShimmerStarted() {
        return this.mValueAnimator != null && this.mValueAnimator.isStarted();
    }

    public void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        int width = bounds.width();
        int height = bounds.height();
        this.mDrawRect.set(0, 0, width, height);
        this.updateShader();
        this.maybeStartShimmer();
    }

    public void draw(@NonNull Canvas canvas) {
        float dy;
        float dx;
        if (this.mShimmer == null || this.mShimmerPaint.getShader() == null) {
            return;
        }
        float tiltTan = (float)Math.tan(Math.toRadians(this.mShimmer.tilt));
        float translateHeight = (float)this.mDrawRect.height() + tiltTan * (float)this.mDrawRect.width();
        float translateWidth = (float)this.mDrawRect.width() + tiltTan * (float)this.mDrawRect.height();
        float animatedValue = this.mValueAnimator != null ? this.mValueAnimator.getAnimatedFraction() : 0.0f;
        switch (this.mShimmer.direction) {
            default: {
                dx = this.offset(-translateWidth, translateWidth, animatedValue);
                dy = 0.0f;
                break;
            }
            case 2: {
                dx = this.offset(translateWidth, -translateWidth, animatedValue);
                dy = 0.0f;
                break;
            }
            case 1: {
                dx = 0.0f;
                dy = this.offset(-translateHeight, translateHeight, animatedValue);
                break;
            }
            case 3: {
                dx = 0.0f;
                dy = this.offset(translateHeight, -translateHeight, animatedValue);
            }
        }
        this.mShaderMatrix.reset();
        this.mShaderMatrix.setRotate(this.mShimmer.tilt, (float)this.mDrawRect.width() / 2.0f, (float)this.mDrawRect.height() / 2.0f);
        this.mShaderMatrix.postTranslate(dx, dy);
        this.mShimmerPaint.getShader().setLocalMatrix(this.mShaderMatrix);
        canvas.drawRect(this.mDrawRect, this.mShimmerPaint);
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return this.mShimmer != null && (this.mShimmer.clipToChildren || this.mShimmer.alphaShimmer) ? -3 : -1;
    }

    private float offset(float start, float end, float percent) {
        return start + (end - start) * percent;
    }

    private void updateValueAnimator() {
        boolean started;
        if (this.mShimmer == null) {
            return;
        }
        if (this.mValueAnimator != null) {
            started = this.mValueAnimator.isStarted();
            this.mValueAnimator.cancel();
            this.mValueAnimator.removeAllUpdateListeners();
        } else {
            started = false;
        }
        this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f + (float)(this.mShimmer.repeatDelay / this.mShimmer.animationDuration)});
        this.mValueAnimator.setRepeatMode(this.mShimmer.repeatMode);
        this.mValueAnimator.setRepeatCount(this.mShimmer.repeatCount);
        this.mValueAnimator.setDuration(this.mShimmer.animationDuration + this.mShimmer.repeatDelay);
        this.mValueAnimator.addUpdateListener(this.mUpdateListener);
        if (started) {
            this.mValueAnimator.start();
        }
    }

    void maybeStartShimmer() {
        if (this.mValueAnimator != null && !this.mValueAnimator.isStarted() && this.mShimmer != null && this.mShimmer.autoStart && this.getCallback() != null) {
            this.mValueAnimator.start();
        }
    }

    private void updateShader() {
        RadialGradient shader;
        Rect bounds = this.getBounds();
        int boundsWidth = bounds.width();
        int boundsHeight = bounds.height();
        if (boundsWidth == 0 || boundsHeight == 0 || this.mShimmer == null) {
            return;
        }
        int width = this.mShimmer.width(boundsWidth);
        int height = this.mShimmer.height(boundsHeight);
        switch (this.mShimmer.shape) {
            default: {
                boolean vertical = this.mShimmer.direction == 1 || this.mShimmer.direction == 3;
                int endX = vertical ? 0 : width;
                int endY = vertical ? height : 0;
                shader = new LinearGradient(0.0f, 0.0f, (float)endX, (float)endY, this.mShimmer.colors, this.mShimmer.positions, Shader.TileMode.CLAMP);
                break;
            }
            case 1: {
                shader = new RadialGradient((float)width / 2.0f, (float)height / 2.0f, (float)((double)Math.max(width, height) / Math.sqrt(2.0)), this.mShimmer.colors, this.mShimmer.positions, Shader.TileMode.CLAMP);
            }
        }
        this.mShimmerPaint.setShader((Shader)shader);
    }
}

