/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine;

import android.util.Log;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.load.Encoder;
import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.load.data.DataFetcher;
import io.intercom.com.bumptech.glide.load.engine.DataCacheGenerator;
import io.intercom.com.bumptech.glide.load.engine.DataCacheKey;
import io.intercom.com.bumptech.glide.load.engine.DataCacheWriter;
import io.intercom.com.bumptech.glide.load.engine.DataFetcherGenerator;
import io.intercom.com.bumptech.glide.load.engine.DecodeHelper;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.util.LogTime;
import java.util.Collections;

class SourceGenerator
implements DataFetcherGenerator,
DataFetcher.DataCallback<Object>,
DataFetcherGenerator.FetcherReadyCallback {
    private static final String TAG = "SourceGenerator";
    private final DecodeHelper<?> helper;
    private final DataFetcherGenerator.FetcherReadyCallback cb;
    private int loadDataListIndex;
    private DataCacheGenerator sourceCacheGenerator;
    private Object dataToCache;
    private volatile ModelLoader.LoadData<?> loadData;
    private DataCacheKey originalKey;

    SourceGenerator(DecodeHelper<?> helper, DataFetcherGenerator.FetcherReadyCallback cb) {
        this.helper = helper;
        this.cb = cb;
    }

    @Override
    public boolean startNext() {
        if (this.dataToCache != null) {
            Object data = this.dataToCache;
            this.dataToCache = null;
            this.cacheData(data);
        }
        if (this.sourceCacheGenerator != null && this.sourceCacheGenerator.startNext()) {
            return true;
        }
        this.sourceCacheGenerator = null;
        this.loadData = null;
        boolean started = false;
        while (!started && this.hasNextModelLoader()) {
            this.loadData = this.helper.getLoadData().get(this.loadDataListIndex++);
            if (this.loadData == null || !this.helper.getDiskCacheStrategy().isDataCacheable(this.loadData.fetcher.getDataSource()) && !this.helper.hasLoadPath(this.loadData.fetcher.getDataClass())) continue;
            started = true;
            this.loadData.fetcher.loadData(this.helper.getPriority(), this);
        }
        return started;
    }

    private boolean hasNextModelLoader() {
        return this.loadDataListIndex < this.helper.getLoadData().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheData(Object dataToCache) {
        long startTime = LogTime.getLogTime();
        try {
            Encoder<Object> encoder = this.helper.getSourceEncoder(dataToCache);
            DataCacheWriter<Object> writer = new DataCacheWriter<Object>(encoder, dataToCache, this.helper.getOptions());
            this.originalKey = new DataCacheKey(this.loadData.sourceKey, this.helper.getSignature());
            this.helper.getDiskCache().put(this.originalKey, writer);
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Finished encoding source to cache, key: " + this.originalKey + ", data: " + dataToCache + ", encoder: " + encoder + ", duration: " + LogTime.getElapsedMillis(startTime)));
            }
        }
        finally {
            this.loadData.fetcher.cleanup();
        }
        this.sourceCacheGenerator = new DataCacheGenerator(Collections.singletonList(this.loadData.sourceKey), this.helper, this);
    }

    @Override
    public void cancel() {
        ModelLoader.LoadData<?> local = this.loadData;
        if (local != null) {
            local.fetcher.cancel();
        }
    }

    @Override
    public void onDataReady(Object data) {
        DiskCacheStrategy diskCacheStrategy = this.helper.getDiskCacheStrategy();
        if (data != null && diskCacheStrategy.isDataCacheable(this.loadData.fetcher.getDataSource())) {
            this.dataToCache = data;
            this.cb.reschedule();
        } else {
            this.cb.onDataFetcherReady(this.loadData.sourceKey, data, this.loadData.fetcher, this.loadData.fetcher.getDataSource(), this.originalKey);
        }
    }

    @Override
    public void onLoadFailed(Exception e) {
        this.cb.onDataFetcherFailed(this.originalKey, e, this.loadData.fetcher, this.loadData.fetcher.getDataSource());
    }

    @Override
    public void reschedule() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onDataFetcherReady(Key sourceKey, Object data, DataFetcher<?> fetcher, DataSource dataSource, Key attemptedKey) {
        this.cb.onDataFetcherReady(sourceKey, data, fetcher, this.loadData.fetcher.getDataSource(), sourceKey);
    }

    @Override
    public void onDataFetcherFailed(Key sourceKey, Exception e, DataFetcher<?> fetcher, DataSource dataSource) {
        this.cb.onDataFetcherFailed(sourceKey, e, fetcher, this.loadData.fetcher.getDataSource());
    }
}

