/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.squareup.otto;

import io.intercom.com.squareup.otto.EventHandler;
import io.intercom.com.squareup.otto.EventProducer;
import io.intercom.com.squareup.otto.Produce;
import io.intercom.com.squareup.otto.Subscribe;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class AnnotatedHandlerFinder {
    private static final ConcurrentMap<Class<?>, Map<Class<?>, Method>> PRODUCERS_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Map<Class<?>, Set<Method>>> SUBSCRIBERS_CACHE = new ConcurrentHashMap();

    private static void loadAnnotatedProducerMethods(Class<?> listenerClass, Map<Class<?>, Method> producerMethods) {
        HashMap subscriberMethods = new HashMap();
        AnnotatedHandlerFinder.loadAnnotatedMethods(listenerClass, producerMethods, subscriberMethods);
    }

    private static void loadAnnotatedSubscriberMethods(Class<?> listenerClass, Map<Class<?>, Set<Method>> subscriberMethods) {
        HashMap producerMethods = new HashMap();
        AnnotatedHandlerFinder.loadAnnotatedMethods(listenerClass, producerMethods, subscriberMethods);
    }

    private static void loadAnnotatedMethods(Class<?> listenerClass, Map<Class<?>, Method> producerMethods, Map<Class<?>, Set<Method>> subscriberMethods) {
        for (Method method : listenerClass.getDeclaredMethods()) {
            Class<?> eventType;
            Class<?>[] parameterTypes;
            if (method.isBridge()) continue;
            if (method.isAnnotationPresent(Subscribe.class)) {
                parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 1) {
                    throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation but requires " + parameterTypes.length + " arguments.  Methods must require a single argument.");
                }
                eventType = parameterTypes[0];
                if (eventType.isInterface()) {
                    throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation on " + eventType + " which is an interface.  Subscription must be on a concrete class type.");
                }
                if ((method.getModifiers() & 1) == 0) {
                    throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation on " + eventType + " but is not 'public'.");
                }
                Set<Method> methods = subscriberMethods.get(eventType);
                if (methods == null) {
                    methods = new HashSet<Method>();
                    subscriberMethods.put(eventType, methods);
                }
                methods.add(method);
                continue;
            }
            if (!method.isAnnotationPresent(Produce.class)) continue;
            parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 0) {
                throw new IllegalArgumentException("Method " + method + "has @Produce annotation but requires " + parameterTypes.length + " arguments.  Methods must require zero arguments.");
            }
            if (method.getReturnType() == Void.class) {
                throw new IllegalArgumentException("Method " + method + " has a return type of void.  Must declare a non-void type.");
            }
            eventType = method.getReturnType();
            if (eventType.isInterface()) {
                throw new IllegalArgumentException("Method " + method + " has @Produce annotation on " + eventType + " which is an interface.  Producers must return a concrete class type.");
            }
            if (eventType.equals(Void.TYPE)) {
                throw new IllegalArgumentException("Method " + method + " has @Produce annotation but has no return type.");
            }
            if ((method.getModifiers() & 1) == 0) {
                throw new IllegalArgumentException("Method " + method + " has @Produce annotation on " + eventType + " but is not 'public'.");
            }
            if (producerMethods.containsKey(eventType)) {
                throw new IllegalArgumentException("Producer for type " + eventType + " has already been registered.");
            }
            producerMethods.put(eventType, method);
        }
        PRODUCERS_CACHE.put(listenerClass, producerMethods);
        SUBSCRIBERS_CACHE.put(listenerClass, subscriberMethods);
    }

    static Map<Class<?>, EventProducer> findAllProducers(Object listener) {
        Class<?> listenerClass = listener.getClass();
        HashMap handlersInMethod = new HashMap();
        HashMap methods = (HashMap)PRODUCERS_CACHE.get(listenerClass);
        if (null == methods) {
            methods = new HashMap();
            AnnotatedHandlerFinder.loadAnnotatedProducerMethods(listenerClass, methods);
        }
        if (!methods.isEmpty()) {
            for (Map.Entry e : methods.entrySet()) {
                EventProducer producer = new EventProducer(listener, (Method)e.getValue());
                handlersInMethod.put((Class<?>)e.getKey(), producer);
            }
        }
        return handlersInMethod;
    }

    static Map<Class<?>, Set<EventHandler>> findAllSubscribers(Object listener) {
        Class<?> listenerClass = listener.getClass();
        HashMap handlersInMethod = new HashMap();
        HashMap methods = (HashMap)SUBSCRIBERS_CACHE.get(listenerClass);
        if (null == methods) {
            methods = new HashMap();
            AnnotatedHandlerFinder.loadAnnotatedSubscriberMethods(listenerClass, methods);
        }
        if (!methods.isEmpty()) {
            for (Map.Entry e : methods.entrySet()) {
                HashSet<EventHandler> handlers = new HashSet<EventHandler>();
                for (Method m : (Set)e.getValue()) {
                    handlers.add(new EventHandler(listener, m));
                }
                handlersInMethod.put((Class<?>)e.getKey(), (Set<EventHandler>)handlers);
            }
        }
        return handlersInMethod;
    }

    private AnnotatedHandlerFinder() {
    }
}

