/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.text.Spanned;
import android.text.method.MovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.HeadingBlock;
import io.intercom.android.sdk.blocks.blockInterfaces.SubheadingBlock;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;

class Heading
implements HeadingBlock,
SubheadingBlock {
    private static final int LARGE_TEXT_SP = 24;
    private static final int MEDIUM_TEXT_SP = 20;
    private static final int SMALL_TEXT_SP = 15;
    private static final int LARGE_MARGIN_BOTTOM_DP = 32;
    private static final int MARGIN_BOTTOM_DP = 16;
    private final StyleType style;
    private final Provider<AppConfig> appConfigProvider;

    Heading(StyleType style2, Provider<AppConfig> appConfigProvider) {
        this.style = style2;
        this.appConfigProvider = appConfigProvider;
    }

    public View addHeading(Spanned text, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        Context context = parent.getContext();
        TextView textView = new TextView(context);
        BlockUtils.createLayoutParams((View)textView, -2, -2);
        int colour = this.appConfigProvider.get().getPrimaryColor();
        switch (this.style) {
            case POST: {
                int lightColour = ColorUtils.lightenColor(colour);
                this.styleAnnouncementHeading(textView, lightColour, 24, 32);
                FontUtils.setRobotoLightTypeface(textView);
                break;
            }
            case NOTE: {
                this.styleAnnouncementHeading(textView, colour, 24, 32);
                break;
            }
            case ARTICLE: {
                this.styleAnnouncementHeading(textView, ColorUtils.primaryOrDarkColor(context, this.appConfigProvider.get()), 24, 32);
                break;
            }
            case CONTAINER_CARD: {
                this.styleAnnouncementHeading(textView, colour, 20, 32);
                break;
            }
            case CHAT_FULL: {
                this.styleChatHeading(textView, ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_800));
                textView.setTypeface(null, 1);
                break;
            }
            default: {
                this.styleChatHeading(textView, ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_800));
                textView.setTypeface(null, 1);
                textView.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
            }
        }
        textView.setText((CharSequence)text);
        textView.setGravity(alignment.getGravity());
        BlockUtils.setLayoutMarginsAndGravity((View)textView, alignment.getGravity(), isLastObject);
        return textView;
    }

    public View addSubheading(Spanned text, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        Context context = parent.getContext();
        TextView textView = new TextView(context);
        BlockUtils.createLayoutParams((View)textView, -2, -2);
        int appColour = this.appConfigProvider.get().getPrimaryColor();
        switch (this.style) {
            case POST: {
                this.styleAnnouncementHeading(textView, ColorUtils.lightenColor(appColour), 15, 16);
                FontUtils.setRobotoLightTypeface(textView);
                break;
            }
            case ARTICLE: {
                this.styleAnnouncementHeading(textView, ColorUtils.primaryOrDarkColor(context, this.appConfigProvider.get()), 15, 16);
                break;
            }
            case NOTE: 
            case CONTAINER_CARD: {
                this.styleAnnouncementHeading(textView, appColour, 15, 16);
                break;
            }
            case CHAT_FULL: {
                this.styleChatHeading(textView, ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_800));
                break;
            }
            default: {
                this.styleChatHeading(textView, appColour);
                textView.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
            }
        }
        textView.setText((CharSequence)text);
        textView.setGravity(alignment.getGravity());
        BlockUtils.setLayoutMarginsAndGravity((View)textView, alignment.getGravity(), isLastObject);
        return textView;
    }

    private void styleChatHeading(TextView textview, int colour) {
        textview.setTextSize(15.0f);
        textview.setTextColor(colour);
        textview.setLinkTextColor(colour);
        BlockUtils.setSmallLineSpacing(textview);
        BlockUtils.setDefaultMarginBottom((View)textview);
    }

    private void styleAnnouncementHeading(TextView textview, @ColorInt int color2, int textSizeSp, int marginBottomDp) {
        textview.setTextSize((float)textSizeSp);
        textview.setTextColor(color2);
        textview.setLinkTextColor(color2);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        BlockUtils.setLargeLineSpacing(textview);
        BlockUtils.setMarginBottom((View)textview, marginBottomDp);
    }
}

