/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.manager;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.Log;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.manager.ActivityFragmentLifecycle;
import io.intercom.com.bumptech.glide.manager.RequestManagerTreeNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RequestManagerFragment
extends Fragment {
    private static final String TAG = "RMFragment";
    private final ActivityFragmentLifecycle lifecycle;
    private final RequestManagerTreeNode requestManagerTreeNode = new FragmentRequestManagerTreeNode();
    private final HashSet<RequestManagerFragment> childRequestManagerFragments = new HashSet();
    @Nullable
    private RequestManager requestManager;
    @Nullable
    private RequestManagerFragment rootRequestManagerFragment;
    @Nullable
    private Fragment parentFragmentHint;

    public RequestManagerFragment() {
        this(new ActivityFragmentLifecycle());
    }

    @SuppressLint(value={"ValidFragment"})
    RequestManagerFragment(ActivityFragmentLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void setRequestManager(@Nullable RequestManager requestManager) {
        this.requestManager = requestManager;
    }

    ActivityFragmentLifecycle getGlideLifecycle() {
        return this.lifecycle;
    }

    @Nullable
    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    public RequestManagerTreeNode getRequestManagerTreeNode() {
        return this.requestManagerTreeNode;
    }

    private void addChildRequestManagerFragment(RequestManagerFragment child) {
        this.childRequestManagerFragments.add(child);
    }

    private void removeChildRequestManagerFragment(RequestManagerFragment child) {
        this.childRequestManagerFragments.remove((Object)child);
    }

    @TargetApi(value=17)
    private Set<RequestManagerFragment> getDescendantRequestManagerFragments() {
        if (this.rootRequestManagerFragment == this) {
            return Collections.unmodifiableSet(this.childRequestManagerFragments);
        }
        if (this.rootRequestManagerFragment == null || Build.VERSION.SDK_INT < 17) {
            return Collections.emptySet();
        }
        HashSet<RequestManagerFragment> descendants = new HashSet<RequestManagerFragment>();
        for (RequestManagerFragment fragment : this.rootRequestManagerFragment.getDescendantRequestManagerFragments()) {
            if (!this.isDescendant(fragment.getParentFragment())) continue;
            descendants.add(fragment);
        }
        return Collections.unmodifiableSet(descendants);
    }

    void setParentFragmentHint(@Nullable Fragment parentFragmentHint) {
        this.parentFragmentHint = parentFragmentHint;
        if (parentFragmentHint != null && parentFragmentHint.getActivity() != null) {
            this.registerFragmentWithRoot(parentFragmentHint.getActivity());
        }
    }

    @TargetApi(value=17)
    private Fragment getParentFragmentUsingHint() {
        Fragment fragment = Build.VERSION.SDK_INT >= 17 ? this.getParentFragment() : null;
        return fragment != null ? fragment : this.parentFragmentHint;
    }

    @TargetApi(value=17)
    private boolean isDescendant(Fragment fragment) {
        Fragment root = this.getParentFragment();
        while (fragment.getParentFragment() != null) {
            if (fragment.getParentFragment() == root) {
                return true;
            }
            fragment = fragment.getParentFragment();
        }
        return false;
    }

    private void registerFragmentWithRoot(Activity activity) {
        this.unregisterFragmentWithRoot();
        this.rootRequestManagerFragment = Glide.get((Context)activity).getRequestManagerRetriever().getRequestManagerFragment(activity.getFragmentManager(), null);
        if (this.rootRequestManagerFragment != this) {
            this.rootRequestManagerFragment.addChildRequestManagerFragment(this);
        }
    }

    private void unregisterFragmentWithRoot() {
        if (this.rootRequestManagerFragment != null) {
            this.rootRequestManagerFragment.removeChildRequestManagerFragment(this);
            this.rootRequestManagerFragment = null;
        }
    }

    public void onAttach(Activity activity) {
        block2: {
            super.onAttach(activity);
            try {
                this.registerFragmentWithRoot(activity);
            }
            catch (IllegalStateException e) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block2;
                Log.w((String)TAG, (String)"Unable to register fragment with root", (Throwable)e);
            }
        }
    }

    public void onDetach() {
        super.onDetach();
        this.unregisterFragmentWithRoot();
    }

    public void onStart() {
        super.onStart();
        this.lifecycle.onStart();
    }

    public void onStop() {
        super.onStop();
        this.lifecycle.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        this.lifecycle.onDestroy();
        this.unregisterFragmentWithRoot();
    }

    public String toString() {
        return super.toString() + "{parent=" + this.getParentFragmentUsingHint() + "}";
    }

    private class FragmentRequestManagerTreeNode
    implements RequestManagerTreeNode {
        FragmentRequestManagerTreeNode() {
        }

        @Override
        public Set<RequestManager> getDescendants() {
            Set descendantFragments = RequestManagerFragment.this.getDescendantRequestManagerFragments();
            HashSet<RequestManager> descendants = new HashSet<RequestManager>(descendantFragments.size());
            for (RequestManagerFragment fragment : descendantFragments) {
                if (fragment.getRequestManager() == null) continue;
                descendants.add(fragment.getRequestManager());
            }
            return descendants;
        }

        public String toString() {
            return super.toString() + "{fragment=" + (Object)((Object)RequestManagerFragment.this) + "}";
        }
    }
}

