/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.manager;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import io.intercom.com.bumptech.glide.manager.ConnectivityMonitor;
import io.intercom.com.bumptech.glide.util.Preconditions;

final class DefaultConnectivityMonitor
implements ConnectivityMonitor {
    private static final String TAG = "ConnectivityMonitor";
    private final Context context;
    final ConnectivityMonitor.ConnectivityListener listener;
    boolean isConnected;
    private boolean isRegistered;
    private final BroadcastReceiver connectivityReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            boolean wasConnected = DefaultConnectivityMonitor.this.isConnected;
            try {
                DefaultConnectivityMonitor.this.isConnected = DefaultConnectivityMonitor.this.isConnected(context);
            }
            catch (SecurityException e) {
                if (Log.isLoggable((String)DefaultConnectivityMonitor.TAG, (int)5)) {
                    Log.w((String)DefaultConnectivityMonitor.TAG, (String)"Failed to determine connectivity status when connectivity changed", (Throwable)e);
                }
                DefaultConnectivityMonitor.this.isConnected = true;
            }
            if (wasConnected != DefaultConnectivityMonitor.this.isConnected) {
                if (Log.isLoggable((String)DefaultConnectivityMonitor.TAG, (int)3)) {
                    Log.d((String)DefaultConnectivityMonitor.TAG, (String)("connectivity changed, isConnected: " + DefaultConnectivityMonitor.this.isConnected));
                }
                DefaultConnectivityMonitor.this.listener.onConnectivityChanged(DefaultConnectivityMonitor.this.isConnected);
            }
        }
    };

    DefaultConnectivityMonitor(Context context, ConnectivityMonitor.ConnectivityListener listener) {
        this.context = context.getApplicationContext();
        this.listener = listener;
    }

    private void register() {
        block3: {
            if (this.isRegistered) {
                return;
            }
            try {
                this.isConnected = this.isConnected(this.context);
                this.context.registerReceiver(this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                this.isRegistered = true;
            }
            catch (SecurityException e) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block3;
                Log.w((String)TAG, (String)"Failed to register", (Throwable)e);
            }
        }
    }

    private void unregister() {
        if (!this.isRegistered) {
            return;
        }
        this.context.unregisterReceiver(this.connectivityReceiver);
        this.isRegistered = false;
    }

    @SuppressLint(value={"MissingPermission"})
    boolean isConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = Preconditions.checkNotNull(connectivityManager).getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    @Override
    public void onStart() {
        this.register();
    }

    @Override
    public void onStop() {
        this.unregister();
    }

    @Override
    public void onDestroy() {
    }
}

