/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.resource.bitmap.DrawableToBitmapConverter;
import io.intercom.com.bumptech.glide.load.resource.bitmap.LazyBitmapDrawableResource;
import java.security.MessageDigest;

public class DrawableTransformation
implements Transformation<Drawable> {
    private final Transformation<Bitmap> wrapped;
    private final boolean isRequired;

    public DrawableTransformation(Transformation<Bitmap> wrapped, boolean isRequired) {
        this.wrapped = wrapped;
        this.isRequired = isRequired;
    }

    public Transformation<BitmapDrawable> asBitmapDrawable() {
        return this;
    }

    @Override
    public Resource<Drawable> transform(Context context, Resource<Drawable> resource, int outWidth, int outHeight) {
        Drawable drawable;
        BitmapPool bitmapPool = Glide.get(context).getBitmapPool();
        Resource<Bitmap> bitmapResourceToTransform = DrawableToBitmapConverter.convert(bitmapPool, drawable = resource.get(), outWidth, outHeight);
        if (bitmapResourceToTransform == null) {
            if (this.isRequired) {
                throw new IllegalArgumentException("Unable to convert " + drawable + " to a Bitmap");
            }
            return resource;
        }
        Resource<Bitmap> transformedBitmapResource = this.wrapped.transform(context, bitmapResourceToTransform, outWidth, outHeight);
        if (transformedBitmapResource.equals(bitmapResourceToTransform)) {
            transformedBitmapResource.recycle();
            return resource;
        }
        return this.newDrawableResource(context, transformedBitmapResource);
    }

    private Resource<Drawable> newDrawableResource(Context context, Resource<Bitmap> transformed) {
        Resource<BitmapDrawable> result = LazyBitmapDrawableResource.obtain(context.getResources(), transformed);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DrawableTransformation) {
            DrawableTransformation other = (DrawableTransformation)o;
            return this.wrapped.equals(other.wrapped);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public void updateDiskCacheKey(MessageDigest messageDigest) {
        this.wrapped.updateDiskCacheKey(messageDigest);
    }
}

