/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.Pools;
import io.intercom.com.bumptech.glide.Priority;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.data.DataFetcher;
import io.intercom.com.bumptech.glide.load.engine.GlideException;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class MultiModelLoader<Model, Data>
implements ModelLoader<Model, Data> {
    private final List<ModelLoader<Model, Data>> modelLoaders;
    private final Pools.Pool<List<Exception>> exceptionListPool;

    MultiModelLoader(List<ModelLoader<Model, Data>> modelLoaders, Pools.Pool<List<Exception>> exceptionListPool) {
        this.modelLoaders = modelLoaders;
        this.exceptionListPool = exceptionListPool;
    }

    @Override
    public ModelLoader.LoadData<Data> buildLoadData(Model model, int width, int height, Options options) {
        Key sourceKey = null;
        int size = this.modelLoaders.size();
        ArrayList fetchers = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            ModelLoader.LoadData<Data> loadData;
            ModelLoader<Model, Data> modelLoader = this.modelLoaders.get(i);
            if (!modelLoader.handles(model) || (loadData = modelLoader.buildLoadData(model, width, height, options)) == null) continue;
            sourceKey = loadData.sourceKey;
            fetchers.add(loadData.fetcher);
        }
        return !fetchers.isEmpty() ? new ModelLoader.LoadData(sourceKey, new MultiFetcher(fetchers, this.exceptionListPool)) : null;
    }

    @Override
    public boolean handles(Model model) {
        for (ModelLoader<Model, Data> modelLoader : this.modelLoaders) {
            if (!modelLoader.handles(model)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "MultiModelLoader{modelLoaders=" + Arrays.toString(this.modelLoaders.toArray(new ModelLoader[this.modelLoaders.size()])) + '}';
    }

    static class MultiFetcher<Data>
    implements DataFetcher<Data>,
    DataFetcher.DataCallback<Data> {
        private final List<DataFetcher<Data>> fetchers;
        private final Pools.Pool<List<Exception>> exceptionListPool;
        private int currentIndex;
        private Priority priority;
        private DataFetcher.DataCallback<? super Data> callback;
        @Nullable
        private List<Exception> exceptions;

        MultiFetcher(List<DataFetcher<Data>> fetchers, Pools.Pool<List<Exception>> exceptionListPool) {
            this.exceptionListPool = exceptionListPool;
            Preconditions.checkNotEmpty(fetchers);
            this.fetchers = fetchers;
            this.currentIndex = 0;
        }

        @Override
        public void loadData(Priority priority, DataFetcher.DataCallback<? super Data> callback) {
            this.priority = priority;
            this.callback = callback;
            this.exceptions = (List)this.exceptionListPool.acquire();
            this.fetchers.get(this.currentIndex).loadData(priority, this);
        }

        @Override
        public void cleanup() {
            if (this.exceptions != null) {
                this.exceptionListPool.release(this.exceptions);
            }
            this.exceptions = null;
            for (DataFetcher<Data> fetcher : this.fetchers) {
                fetcher.cleanup();
            }
        }

        @Override
        public void cancel() {
            for (DataFetcher<Data> fetcher : this.fetchers) {
                fetcher.cancel();
            }
        }

        @Override
        @NonNull
        public Class<Data> getDataClass() {
            return this.fetchers.get(0).getDataClass();
        }

        @Override
        @NonNull
        public DataSource getDataSource() {
            return this.fetchers.get(0).getDataSource();
        }

        @Override
        public void onDataReady(Data data) {
            if (data != null) {
                this.callback.onDataReady(data);
            } else {
                this.startNextOrFail();
            }
        }

        @Override
        public void onLoadFailed(Exception e) {
            this.exceptions.add(e);
            this.startNextOrFail();
        }

        private void startNextOrFail() {
            if (this.currentIndex < this.fetchers.size() - 1) {
                ++this.currentIndex;
                this.loadData(this.priority, this.callback);
            } else {
                this.callback.onLoadFailed(new GlideException("Fetch failed", new ArrayList<Exception>(this.exceptions)));
            }
        }
    }
}

