/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import android.support.annotation.NonNull;
import io.intercom.com.bumptech.glide.Priority;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.data.DataFetcher;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.load.model.ModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.model.MultiModelLoaderFactory;
import io.intercom.com.bumptech.glide.signature.ObjectKey;

public class UnitModelLoader<Model>
implements ModelLoader<Model, Model> {
    @Override
    public ModelLoader.LoadData<Model> buildLoadData(Model model, int width, int height, Options options) {
        return new ModelLoader.LoadData<Model>(new ObjectKey(model), new UnitFetcher<Model>(model));
    }

    @Override
    public boolean handles(Model model) {
        return true;
    }

    public static class Factory<Model>
    implements ModelLoaderFactory<Model, Model> {
        @Override
        public ModelLoader<Model, Model> build(MultiModelLoaderFactory multiFactory) {
            return new UnitModelLoader();
        }

        @Override
        public void teardown() {
        }
    }

    private static class UnitFetcher<Model>
    implements DataFetcher<Model> {
        private final Model resource;

        public UnitFetcher(Model resource) {
            this.resource = resource;
        }

        @Override
        public void loadData(Priority priority, DataFetcher.DataCallback<? super Model> callback) {
            callback.onDataReady(this.resource);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void cancel() {
        }

        @Override
        @NonNull
        public Class<Model> getDataClass() {
            return this.resource.getClass();
        }

        @Override
        @NonNull
        public DataSource getDataSource() {
            return DataSource.LOCAL;
        }
    }
}

