/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.experimental;

import android.app.Application;
import android.app.TaskStackBuilder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.LateInitializationPreparer;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.UserAttributes;
import io.intercom.android.sdk.experimental.IntercomSettings;
import io.intercom.android.sdk.experimental.InvalidIntercom;
import io.intercom.android.sdk.experimental.RealIntercom;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.ValidatorUtil;
import java.util.Map;

public abstract class Intercom {
    public static final String GCM_RECEIVER = "intercom_sdk";
    private static final Twig TWIG = LumberMill.getLogger();
    @Nullable
    private static Intercom instance;

    public static synchronized void boot(Application application, IntercomSettings settings) {
        if (instance == null) {
            if (ValidatorUtil.isValidConstructorParams(application, settings.getApiKey(), settings.getAppId())) {
                instance = RealIntercom.create(application, settings.getApiKey(), settings.getAppId());
                LateInitializationPreparer.getInstance().handlePastLifecycleEvents(application, Injector.get());
                ((RealIntercom)instance).registerUser(settings);
            } else {
                instance = new InvalidIntercom();
            }
        } else if (instance instanceof RealIntercom) {
            ((RealIntercom)instance).registerUser(settings);
        }
    }

    public static synchronized void registerForLaterBoot(@NonNull Application application) {
        if (instance != null) {
            TWIG.i("Intercom has already been booted", new Object[0]);
            return;
        }
        if (application == null) {
            throw new NullPointerException("Cannot call registerForLaterBoot() with a null Application");
        }
        LateInitializationPreparer.getInstance().register(application);
    }

    public static void unregisterForLateBoot(@NonNull Application application) {
        if (application == null) {
            throw new NullPointerException("Cannot call unregisterForLateBoot() with a null Application");
        }
        LateInitializationPreparer.getInstance().unregister(application);
    }

    public static synchronized Intercom client() {
        if (instance == null) {
            throw new IllegalStateException("Please call Intercom.boot() before requesting the client.");
        }
        return instance;
    }

    public abstract void setUserHash(String var1);

    public abstract void updateUser(UserAttributes var1);

    public abstract void logEvent(String var1);

    public abstract void logEvent(String var1, Map<String, ?> var2);

    public abstract void displayMessenger();

    public abstract void displayMessageComposer();

    public abstract void displayMessageComposer(String var1);

    public abstract void displayConversationsList();

    public abstract void setBottomPadding(int var1);

    public abstract void setInAppMessageVisibility(Intercom.Visibility var1);

    public abstract void setLauncherVisibility(Intercom.Visibility var1);

    public abstract void hideMessenger();

    public abstract void handlePushMessage();

    public abstract void handlePushMessage(TaskStackBuilder var1);

    public abstract void shutdown();

    public abstract int getUnreadConversationCount();

    public abstract void addUnreadConversationCountListener(@NonNull UnreadConversationCountListener var1);

    public abstract void removeUnreadConversationCountListener(UnreadConversationCountListener var1);

    public static void setLogLevel(@Intercom.LogLevel int logLevel) {
        LumberMill.setLogLevel(logLevel);
    }
}

