/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import android.net.Uri;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.load.model.Headers;
import io.intercom.com.bumptech.glide.util.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Map;

public class GlideUrl
implements Key {
    private static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";
    private final Headers headers;
    @Nullable
    private final URL url;
    @Nullable
    private final String stringUrl;
    @Nullable
    private String safeStringUrl;
    @Nullable
    private URL safeUrl;
    @Nullable
    private volatile byte[] cacheKeyBytes;
    private int hashCode;

    public GlideUrl(URL url) {
        this(url, Headers.DEFAULT);
    }

    public GlideUrl(String url) {
        this(url, Headers.DEFAULT);
    }

    public GlideUrl(URL url, Headers headers) {
        this.url = Preconditions.checkNotNull(url);
        this.stringUrl = null;
        this.headers = Preconditions.checkNotNull(headers);
    }

    public GlideUrl(String url, Headers headers) {
        this.url = null;
        this.stringUrl = Preconditions.checkNotEmpty(url);
        this.headers = Preconditions.checkNotNull(headers);
    }

    public URL toURL() throws MalformedURLException {
        return this.getSafeUrl();
    }

    private URL getSafeUrl() throws MalformedURLException {
        if (this.safeUrl == null) {
            this.safeUrl = new URL(this.getSafeStringUrl());
        }
        return this.safeUrl;
    }

    public String toStringUrl() {
        return this.getSafeStringUrl();
    }

    private String getSafeStringUrl() {
        if (TextUtils.isEmpty((CharSequence)this.safeStringUrl)) {
            String unsafeStringUrl = this.stringUrl;
            if (TextUtils.isEmpty((CharSequence)unsafeStringUrl)) {
                unsafeStringUrl = this.url.toString();
            }
            this.safeStringUrl = Uri.encode((String)unsafeStringUrl, (String)ALLOWED_URI_CHARS);
        }
        return this.safeStringUrl;
    }

    public Map<String, String> getHeaders() {
        return this.headers.getHeaders();
    }

    public String getCacheKey() {
        return this.stringUrl != null ? this.stringUrl : this.url.toString();
    }

    public String toString() {
        return this.getCacheKey();
    }

    @Override
    public void updateDiskCacheKey(MessageDigest messageDigest) {
        messageDigest.update(this.getCacheKeyBytes());
    }

    private byte[] getCacheKeyBytes() {
        if (this.cacheKeyBytes == null) {
            this.cacheKeyBytes = this.getCacheKey().getBytes(CHARSET);
        }
        return this.cacheKeyBytes;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof GlideUrl) {
            GlideUrl other = (GlideUrl)o;
            return this.getCacheKey().equals(other.getCacheKey()) && this.headers.equals(other.headers);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.getCacheKey().hashCode();
            this.hashCode = 31 * this.hashCode + this.headers.hashCode();
        }
        return this.hashCode;
    }
}

