/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.content.Context;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.IntercomArticleActivity;
import io.intercom.android.sdk.conversation.ConversationContentPresenter;
import io.intercom.android.sdk.conversation.WebViewConversationAction;
import io.intercom.android.sdk.lightbox.LightBoxActivity;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.com.google.gson.Gson;
import java.util.List;

public class WebViewHostWrapper {
    private static final String CONVERSATION_CHANGED = "CONVERSATION_CHANGED";
    private static final String IMAGE_CLICKED = "IMAGE_CLICKED";
    private static final String ARTICLE_CARD_CLICKED = "ARTICLE_CARD_CLICKED";
    private static final String POST_CARD_CLICKED = "POST_CARD_CLICKED";
    private static final String OPS_METRIC_EVENT = "OPS_METRIC_EVENT";
    private final ConversationContentPresenter.Host host;
    private final WebView webView;
    private final Gson gson;
    private final Store<State> store;
    private final List<Part> parts;
    private final OpsMetricTracker opsMetricTracker;

    WebViewHostWrapper(ConversationContentPresenter.Host host, WebView webView, Gson gson, Store<State> store, List<Part> parts, OpsMetricTracker opsMetricTracker) {
        this.host = host;
        this.webView = webView;
        this.gson = gson;
        this.store = store;
        this.parts = parts;
        this.opsMetricTracker = opsMetricTracker;
    }

    @JavascriptInterface
    public void handleAction(String actionJson) {
        final WebViewConversationAction action = (WebViewConversationAction)this.gson.fromJson(actionJson, WebViewConversationAction.class);
        switch (action.getType()) {
            case "CONVERSATION_CHANGED": {
                String conversationJson = this.gson.toJson(action.getValue().get("conversation"));
                final Conversation conversation = ((Conversation.Builder)this.gson.fromJson(conversationJson, Conversation.Builder.class)).build();
                this.parts.clear();
                this.parts.addAll(conversation.getParts());
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!WebViewHostWrapper.this.host.getConversationId().isEmpty()) {
                            WebViewHostWrapper.this.store.dispatch(Actions.fetchConversationSuccess(conversation));
                        }
                        if (WebViewHostWrapper.this.host.getConversationId().isEmpty() && !conversation.getParts().isEmpty()) {
                            WebViewHostWrapper.this.store.dispatch(Actions.newConversationSuccess(conversation));
                            WebViewHostWrapper.this.host.onConversationCreated(conversation);
                        } else {
                            WebViewHostWrapper.this.host.onConversationUpdated(conversation);
                        }
                    }
                });
                break;
            }
            case "IMAGE_CLICKED": {
                final Context context = this.webView.getContext();
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        String imageUrl = (String)action.getValue().get("src");
                        if (imageUrl != null) {
                            context.startActivity(LightBoxActivity.imageIntent(context, imageUrl, false, 0, 0));
                        }
                    }
                });
                break;
            }
            case "ARTICLE_CARD_CLICKED": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        String articleId = (String)action.getValue().get("articleId");
                        if (articleId != null) {
                            Context context = WebViewHostWrapper.this.webView.getContext();
                            context.startActivity(IntercomArticleActivity.buildIntent(context, articleId, WebViewHostWrapper.this.host.getConversationId()));
                        }
                    }
                });
                break;
            }
            case "POST_CARD_CLICKED": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        WebViewHostWrapper.this.host.onPostCardClicked();
                    }
                });
                break;
            }
            case "OPS_METRIC_EVENT": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        String eventType = (String)action.getValue().get("eventType");
                        String event = (String)action.getValue().get("event");
                        WebViewHostWrapper.this.opsMetricTracker.trackEvent(eventType, event);
                    }
                });
                break;
            }
        }
    }
}

