/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;

public class NexusClientMiddleware
implements Store.Middleware<State> {
    private final Provider<NexusClient> nexusClient;
    private final Provider<AppConfig> appConfigProvider;

    public NexusClientMiddleware(Provider<NexusClient> nexusClient, Provider<AppConfig> appConfigProvider) {
        this.nexusClient = nexusClient;
        this.appConfigProvider = appConfigProvider;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case APP_ENTERED_FOREGROUND: {
                this.client().connect(this.appConfigProvider.get().getRealTimeConfig(), true);
                break;
            }
            case APP_ENTERED_BACKGROUND: {
                this.client().disconnect();
                break;
            }
            case SOFT_RESET: {
                this.client().disconnect();
                break;
            }
            case BASE_RESPONSE_RECEIVED: {
                NexusConfig config = ((BaseResponse)action.value()).getConfig().getRealTimeConfig();
                if (config.getEndpoints().isEmpty()) {
                    this.client().disconnect();
                    break;
                }
                if (store.state().hostAppState().isBackgrounded()) break;
                this.client().connect(config, true);
                break;
            }
        }
    }

    private NexusClient client() {
        return this.nexusClient.get();
    }
}

