/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.AppTypeDetector;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.com.google.gson.Gson;
import io.intercom.okio.BufferedSink;
import io.intercom.okio.BufferedSource;
import io.intercom.okio.Okio;
import io.intercom.okio.Sink;
import io.intercom.okio.Source;
import io.intercom.retrofit2.Call;
import io.intercom.retrofit2.Callback;
import io.intercom.retrofit2.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class MetricsStore {
    private static final Executor IO_EXECUTOR = Executors.newSingleThreadExecutor();
    private static final String METRICS_DISK_CACHE = "intercomMetricsDiskCache";
    private static final String DELIMITER = "~";
    @VisibleForTesting
    final List<MetricObject> metrics = Collections.synchronizedList(new ArrayList());
    private final Gson gson = new Gson();
    private final Provider<AppConfig> appConfigProvider;
    private final Executor ioExecutor;
    final Context context;
    private final Provider<Api> apiProvider;
    private final String installerPackageName;
    private final boolean isDebugBuild;
    private final Twig twig = LumberMill.getLogger();

    public MetricsStore(Context context, Provider<Api> apiProvider, Provider<AppConfig> appConfigProvider) {
        this(context, apiProvider, appConfigProvider, IO_EXECUTOR);
    }

    @VisibleForTesting
    MetricsStore(Context context, Provider<Api> apiProvider, Provider<AppConfig> appConfigProvider, Executor ioExecutor) {
        this.context = context;
        this.apiProvider = apiProvider;
        this.appConfigProvider = appConfigProvider;
        this.ioExecutor = ioExecutor;
        this.isDebugBuild = AppTypeDetector.isDebugBuild(context);
        this.installerPackageName = AppTypeDetector.getInstallerPackageName(context);
    }

    public void track(MetricObject metric) {
        if (this.appConfigProvider.get().isMetricsEnabled()) {
            this.metrics.add(metric.addInstallerPackageName(this.installerPackageName).addIsDebugBuild(this.isDebugBuild));
            this.persistMetricToDiskOnWorkerThread(metric);
            this.twig.internal("metrics", String.format("tracked %s", metric));
        } else {
            this.twig.internal("Metrics have been remotely disabled");
        }
    }

    public void loadAndSendCachedMetrics() {
        this.ioExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MetricsStore.this.readMetricsFromDisk();
                    MetricsStore.this.sendMetrics();
                }
                catch (IOException e) {
                    MetricsStore.this.twig.internal("Couldn't read metric from disk: " + e.getMessage());
                }
            }
        });
    }

    public void sendMetrics() {
        if (!this.metrics.isEmpty()) {
            final ArrayList<MetricObject> sentMetrics = new ArrayList<MetricObject>(this.metrics);
            this.apiProvider.get().sendMetrics(sentMetrics, new Callback<Void>(){

                public void onResponse(Call<Void> call, Response<Void> response) {
                    if (response.isSuccessful()) {
                        MetricsStore.this.cleanUpMetrics(sentMetrics);
                    }
                }

                public void onFailure(Call<Void> call, Throwable t) {
                }
            });
        }
    }

    @VisibleForTesting
    void cleanUpMetrics(List<MetricObject> sentMetrics) {
        this.metrics.removeAll(sentMetrics);
        this.ioExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MetricsStore.this.context.deleteFile(MetricsStore.METRICS_DISK_CACHE);
            }
        });
        if (!this.metrics.isEmpty()) {
            for (MetricObject o : this.metrics) {
                this.persistMetricToDiskOnWorkerThread(o);
            }
        }
    }

    @VisibleForTesting
    void persistMetricToDiskOnWorkerThread(final MetricObject metricObject) {
        this.ioExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MetricsStore.this.persistMetricToDisk(metricObject);
                }
                catch (IOException e) {
                    MetricsStore.this.twig.internal("Couldn't persist metric to disk: " + e.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void persistMetricToDisk(MetricObject metricObject) throws IOException {
        try (BufferedSink bufferedSink = null;){
            bufferedSink = Okio.buffer((Sink)Okio.sink((OutputStream)this.context.openFileOutput(METRICS_DISK_CACHE, 32768)));
            String jsonString = this.gson.toJson((Object)metricObject) + DELIMITER;
            bufferedSink.writeUtf8(jsonString);
            bufferedSink.flush();
        }
    }

    @WorkerThread
    void readMetricsFromDisk() throws IOException {
        String[] objectsAsJson;
        String file;
        try (BufferedSource bufferedSource = null;){
            bufferedSource = Okio.buffer((Source)Okio.source((InputStream)this.context.openFileInput(METRICS_DISK_CACHE)));
            file = bufferedSource.readUtf8();
        }
        for (String jsonString : objectsAsJson = file.split(DELIMITER)) {
            try {
                this.metrics.add((MetricObject)this.gson.fromJson(jsonString, MetricObject.class));
            }
            catch (Exception e) {
                this.twig.internal("Could not parse metric: " + jsonString);
            }
        }
    }
}

