/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

class AppTypeDetector {
    private static final X500Principal DEBUG_DN = new X500Principal("CN=Android Debug,O=Android,C=US");
    private static final Twig twig = LumberMill.getLogger();

    AppTypeDetector() {
    }

    static boolean isDebugBuild(Context context) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo packageInfo = manager.getPackageInfo(context.getPackageName(), 64);
            Signature[] signatures = packageInfo.signatures;
            if (signatures != null && signatures.length > 0) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                for (Signature signature : signatures) {
                    byte[] buf = signature.toByteArray();
                    ByteArrayInputStream stream = new ByteArrayInputStream(buf);
                    X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(stream);
                    if (!cert.getSubjectX500Principal().equals(DEBUG_DN)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            twig.internal("Debug build status is unknown, error: " + e.getMessage());
        }
        return false;
    }

    @Nullable
    static String getInstallerPackageName(Context context) {
        String result = null;
        try {
            result = context.getPackageManager().getInstallerPackageName(context.getPackageName());
        }
        catch (Exception e) {
            twig.internal("Package name is unknown, error: " + e.getMessage());
        }
        if (TextUtils.isEmpty((CharSequence)result)) {
            result = "unknown";
        }
        return result;
    }
}

