/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.state.OverlayState;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.ActivityUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class OverlayStateReducer
implements Store.Reducer<OverlayState> {
    @SuppressLint(value={"StaticFieldLeak"})
    static final OverlayState INITIAL_STATE = new OverlayState(Collections.emptyList(), Collections.emptySet(), Intercom.Visibility.VISIBLE, Intercom.Visibility.GONE, null, null);

    OverlayStateReducer() {
    }

    @Override
    public OverlayState reduce(Action<?> action, OverlayState current) {
        switch (action.type()) {
            case SET_IN_APP_NOTIFICATION_VISIBILITY: {
                return new OverlayState(current.conversations(), current.dismissedPartIds(), (Intercom.Visibility)((Object)action.value()), current.launcherVisibility(), current.resumedHostActivity(), current.pausedHostActivity());
            }
            case SET_LAUNCHER_VISIBILITY: {
                return new OverlayState(current.conversations(), current.dismissedPartIds(), current.notificationVisibility(), (Intercom.Visibility)((Object)action.value()), current.resumedHostActivity(), current.pausedHostActivity());
            }
            case HARD_RESET: {
                return new OverlayState(Collections.emptyList(), Collections.emptySet(), current.notificationVisibility(), current.launcherVisibility(), current.resumedHostActivity(), current.pausedHostActivity());
            }
            case CONVERSATION_MARKED_AS_READ: {
                ArrayList<Conversation> conversations = new ArrayList<Conversation>(current.conversations());
                OverlayStateReducer.removeConversationWithId(conversations, (String)action.value());
                return new OverlayState(conversations, current.dismissedPartIds(), current.notificationVisibility(), current.launcherVisibility(), current.resumedHostActivity(), current.pausedHostActivity());
            }
            case CONVERSATION_MARKED_AS_DISMISSED: {
                Conversation conversation = (Conversation)action.value();
                ArrayList<Conversation> conversations = new ArrayList<Conversation>(current.conversations());
                HashSet<String> dismissedPartIds = new HashSet<String>(current.dismissedPartIds());
                dismissedPartIds.add(conversation.getLastPart().getId());
                OverlayStateReducer.removeDismissedConversations(conversations, dismissedPartIds);
                return new OverlayState(conversations, dismissedPartIds, current.notificationVisibility(), current.launcherVisibility(), current.resumedHostActivity(), current.pausedHostActivity());
            }
            case UNREAD_CONVERSATIONS_SUCCESS: {
                UsersResponse response = (UsersResponse)action.value();
                List<Conversation> receivedConversations = response.getUnreadConversations().getConversations();
                ArrayList<Conversation> conversations = new ArrayList<Conversation>(receivedConversations);
                OverlayStateReducer.removeDismissedConversations(conversations, current.dismissedPartIds());
                OverlayStateReducer.removeBadgeConversations(conversations);
                return new OverlayState(conversations, current.dismissedPartIds(), current.notificationVisibility(), current.launcherVisibility(), current.resumedHostActivity(), current.pausedHostActivity());
            }
            case ACTIVITY_READY_FOR_VIEW_ATTACHMENT: {
                Activity newActivity = (Activity)action.value();
                Activity newHostActivity = ActivityUtils.isHostActivity(newActivity) ? newActivity : null;
                return OverlayStateReducer.newStateIfNewHostActivity(current, newHostActivity, null);
            }
            case ACTIVITY_PAUSED: {
                return OverlayStateReducer.newStateIfNewHostActivity(current, null, (Activity)action.value());
            }
            case ACTIVITY_STOPPED: {
                Activity stoppedActivity = (Activity)action.value();
                Activity newPausedActivity = stoppedActivity == current.pausedHostActivity() ? null : current.pausedHostActivity();
                return OverlayStateReducer.newStateIfNewHostActivity(current, current.resumedHostActivity(), newPausedActivity);
            }
            case APP_ENTERED_BACKGROUND: {
                return OverlayStateReducer.newStateIfNewHostActivity(current, null, null);
            }
        }
        return current;
    }

    private static void removeConversationWithId(List<Conversation> conversations, String conversationId) {
        for (Conversation conversation : conversations) {
            if (!conversation.getId().equals(conversationId)) continue;
            conversations.remove(conversation);
            break;
        }
    }

    private static OverlayState newStateIfNewHostActivity(OverlayState current, @Nullable Activity resumingActivity, @Nullable Activity pausingActivity) {
        if (current.resumedHostActivity() == resumingActivity && current.pausedHostActivity() == pausingActivity) {
            return current;
        }
        return new OverlayState(current.conversations(), current.dismissedPartIds(), current.notificationVisibility(), current.launcherVisibility(), resumingActivity, pausingActivity);
    }

    private static void removeDismissedConversations(List<Conversation> conversations, Set<String> dismissedPartIds) {
        for (int i = conversations.size() - 1; i >= 0; --i) {
            if (!dismissedPartIds.contains(conversations.get(i).getLastPart().getId())) continue;
            conversations.remove(i);
        }
    }

    private static void removeBadgeConversations(List<Conversation> conversations) {
        for (int i = conversations.size() - 1; i >= 0; --i) {
            if (conversations.get(i).getLastPart().getDeliveryOption() != Part.DeliveryOption.BADGE) continue;
            conversations.remove(i);
        }
    }
}

