/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.push.PushHandler;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import java.util.Map;

public class IntercomPushClient {
    private final Twig twig = LumberMill.getLogger();
    private final PushHandler pushHandler = new PushHandler();

    public void sendTokenToIntercom(Application application, String token) {
        Injector.init(application);
        if (this.pushHandler.shouldSendDeviceToken((Context)application, token)) {
            this.pushHandler.sendTokenToIntercom((Context)application, token, Injector.get().getApi());
        }
    }

    public void handlePush(Application application, Bundle message) {
        if (!this.isIntercomPush(message)) {
            this.twig.i("The message passed to handlePush was not an Intercom push message.", new Object[0]);
            return;
        }
        Injector.init(application);
        Context localisedContext = new ContextLocaliser(Injector.get().getAppIdentity()).createLocalisedContext((Context)application);
        boolean appBackgrounded = Injector.get().getStore().state().hostAppState().isBackgrounded();
        UserIdentity userIdentity = Injector.get().getUserIdentity();
        MetricFactory metricFactory = new MetricFactory(userIdentity);
        SystemNotificationManager systemNotificationManager = Injector.get().getSystemNotificationManager();
        this.pushHandler.handlePush(message, userIdentity, systemNotificationManager, Injector.get().getMetricsStore(), appBackgrounded, localisedContext, metricFactory);
    }

    public void handlePush(Application application, Map<String, String> message) {
        this.handlePush(application, this.convertMessageMapToBundle(message));
    }

    public boolean isIntercomPush(Bundle message) {
        return this.pushHandler.isIntercomPush(message);
    }

    public boolean isIntercomPush(Map<String, String> message) {
        return this.isIntercomPush(this.convertMessageMapToBundle(message));
    }

    private Bundle convertMessageMapToBundle(Map<String, String> message) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : message.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }
}

