/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.overlay.DefaultLauncher;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;

class DefaultLauncherPresenter
implements DefaultLauncher.Listener {
    private final LayoutInflater inflater;
    private final AppConfig.Provider appConfigProvider;
    private final LauncherOpenBehaviour openBehaviour;
    private final MetricsStore metricsStore;
    private final MetricFactory metricFactory;
    @Nullable
    private DefaultLauncher defaultLauncher;
    private int previousUnreadCount = 0;

    DefaultLauncherPresenter(LayoutInflater inflater, AppConfig.Provider appConfigProvider, LauncherOpenBehaviour openBehaviour, MetricsStore metricsStore, MetricFactory metricFactory) {
        this.inflater = inflater;
        this.appConfigProvider = appConfigProvider;
        this.openBehaviour = openBehaviour;
        this.metricsStore = metricsStore;
        this.metricFactory = metricFactory;
    }

    void displayLauncherOnAttachedRoot(ViewGroup root) {
        if (this.defaultLauncher != null && !this.defaultLauncher.isAttachedToRoot(root)) {
            this.defaultLauncher.removeView();
            this.defaultLauncher = null;
        }
        if (this.defaultLauncher == null) {
            int color2 = this.appConfigProvider.getAppConfig().getBaseColor();
            this.defaultLauncher = new DefaultLauncher(root, this.inflater, this, color2);
            this.defaultLauncher.fadeOnScreen();
        }
        this.setUnreadCount(this.previousUnreadCount);
    }

    DefaultLauncher getAndUnsetLauncher() {
        DefaultLauncher localLauncher = this.defaultLauncher;
        this.defaultLauncher = null;
        return localLauncher;
    }

    void updateLauncherBackground() {
        if (this.defaultLauncher != null) {
            this.defaultLauncher.updateColor(this.appConfigProvider.getAppConfig().getBaseColor());
        }
    }

    void removeLauncher() {
        if (this.defaultLauncher != null) {
            this.defaultLauncher.fadeOffScreen(null);
            this.defaultLauncher = null;
        }
    }

    public boolean isDisplaying() {
        return this.defaultLauncher != null;
    }

    public void setUnreadCount(int unreadCount) {
        if (this.isDisplaying()) {
            String unreadCountText = String.valueOf(unreadCount);
            if (unreadCount > this.previousUnreadCount) {
                this.metricsStore.track(this.metricFactory.receivedNotificationFromBadgeWhenMessengerClosed(unreadCountText));
            }
            if (unreadCount > 0) {
                this.defaultLauncher.setBadgeCount(unreadCountText);
            } else {
                this.defaultLauncher.hideBadgeCount();
            }
        }
        this.previousUnreadCount = unreadCount;
    }

    @Override
    public void onLauncherClicked(Context context) {
        this.openBehaviour.openMessenger(context);
    }
}

