/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import android.support.v4.util.SimpleArrayMap;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.state.OverlayState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import java.util.List;
import java.util.Set;

public class AudioMiddleware
implements Store.Middleware<State> {
    private final SimpleArrayMap<String, String> playedPartIdsForConversations = new SimpleArrayMap();
    private final SoundPlayer soundPlayer;
    private final UserIdentity userIdentity;

    public AudioMiddleware(SoundPlayer soundPlayer, UserIdentity userIdentity) {
        this.soundPlayer = soundPlayer;
        this.userIdentity = userIdentity;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        if (this.userIdentity.isSoftReset()) {
            return;
        }
        switch (action.type()) {
            case UNREAD_CONVERSATIONS_SUCCESS: 
            case ACTIVITY_READY_FOR_VIEW_ATTACHMENT: 
            case SET_IN_APP_NOTIFICATION_VISIBILITY: {
                OverlayState overlayState = store.select(Selectors.OVERLAY);
                if (AudioMiddleware.notificationsDisabled(overlayState) || AudioMiddleware.noActivityForOverlays(overlayState)) break;
                Set<String> dismissedPartIds = overlayState.dismissedPartIds();
                List<Conversation> conversations = overlayState.conversations();
                boolean playAudio = false;
                for (Conversation conversation : conversations) {
                    Part lastPart = conversation.getLastPart();
                    if (lastPart == Part.NULL || dismissedPartIds.contains(lastPart.getId())) continue;
                    playAudio = playAudio || this.neverPlayedAudioFor(conversation, lastPart);
                    this.playedPartIdsForConversations.put((Object)conversation.getId(), (Object)lastPart.getId());
                }
                if (!playAudio) break;
                this.soundPlayer.playMessageReceivedSound();
                break;
            }
            case HARD_RESET: {
                this.playedPartIdsForConversations.clear();
                break;
            }
        }
    }

    private boolean neverPlayedAudioFor(Conversation conversation, Part lastPart) {
        String lastPartWithAudioPlayed = (String)this.playedPartIdsForConversations.get((Object)conversation.getId());
        return !lastPart.getId().equals(lastPartWithAudioPlayed);
    }

    private static boolean noActivityForOverlays(OverlayState overlayState) {
        return overlayState.resumedHostActivity() == null;
    }

    private static boolean notificationsDisabled(OverlayState overlayState) {
        return overlayState.notificationVisibility() != Intercom.Visibility.VISIBLE;
    }
}

