/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.galleryinput;

import android.content.Context;
import android.graphics.drawable.Drawable;
import com.intercom.composer.Creator;
import com.intercom.composer.input.IconProvider;
import com.intercom.composer.input.Input;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.input.gallery.GalleryInput;
import com.intercom.input.gallery.GalleryInputExpandedListener;
import com.intercom.input.gallery.GalleryInputFragment;
import com.intercom.input.gallery.GalleryOutputListener;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.composer.ComposerManager;
import io.intercom.android.sdk.conversation.composer.InputDrawableManager;
import io.intercom.android.sdk.conversation.composer.galleryinput.GifInputFragment;
import io.intercom.android.sdk.conversation.composer.galleryinput.LocalGalleryInputFragment;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;

public class GalleryInputManager {
    private static final String INPUT_EXPANDED_PREFIX = "expanded_";
    private final Drawable galleryIcon;
    private final Drawable gifIcon;
    private final ComposerManager.Listener listener;
    private final MetricsStore metricsStore;
    private final MetricFactory metricFactory;
    private String conversationId;

    public GalleryInputManager(Context context, InputDrawableManager inputDrawableManager, ComposerManager.Listener listener, MetricsStore metricStore, MetricFactory metricFactory, String conversationId) {
        this.listener = listener;
        this.metricsStore = metricStore;
        this.metricFactory = metricFactory;
        this.conversationId = conversationId;
        this.galleryIcon = inputDrawableManager.createDrawable(context, R.drawable.intercom_input_gallery);
        this.gifIcon = inputDrawableManager.createDrawable(context, R.drawable.intercom_input_gif);
    }

    public Input createGalleryInput() {
        IconProvider iconProvider = new IconProvider(){

            @Override
            public Drawable getIconDrawable(String inputIdentifier, Context context) {
                return GalleryInputManager.this.galleryIcon;
            }
        };
        GalleryOutputListener outputListener = new GalleryOutputListener(){

            @Override
            public void onGalleryOutputReceived(GalleryImage galleryImage) {
                GalleryInputManager.this.listener.onGalleryImageSelected(galleryImage);
            }
        };
        GalleryInputExpandedListener galleryInputExpandedListener = new GalleryInputExpandedListener(){

            @Override
            public void onInputExpanded() {
                GalleryInputManager.this.metricsStore.track(GalleryInputManager.this.metricFactory.expandedInput(GalleryInputManager.this.conversationId, "expanded_gallery_input"));
            }
        };
        Creator<GalleryInputFragment> fragmentCreator = new Creator<GalleryInputFragment>(){

            @Override
            public GalleryInputFragment create() {
                return new LocalGalleryInputFragment();
            }
        };
        return new GalleryInput("gallery_input", iconProvider, outputListener, galleryInputExpandedListener, fragmentCreator);
    }

    public Input createGifInput() {
        IconProvider iconProvider = new IconProvider(){

            @Override
            public Drawable getIconDrawable(String inputIdentifier, Context context) {
                return GalleryInputManager.this.gifIcon;
            }
        };
        GalleryOutputListener outputListener = new GalleryOutputListener(){

            @Override
            public void onGalleryOutputReceived(GalleryImage galleryImage) {
                GalleryInputManager.this.listener.onGalleryImageSelected(galleryImage);
            }
        };
        GalleryInputExpandedListener galleryInputExpandedListener = new GalleryInputExpandedListener(){

            @Override
            public void onInputExpanded() {
                GalleryInputManager.this.metricsStore.track(GalleryInputManager.this.metricFactory.expandedInput(GalleryInputManager.this.conversationId, "expanded_gif_input"));
            }
        };
        Creator<GalleryInputFragment> fragmentCreator = new Creator<GalleryInputFragment>(){

            @Override
            public GalleryInputFragment create() {
                return new GifInputFragment();
            }
        };
        return new GalleryInput("gif_input", iconProvider, outputListener, galleryInputExpandedListener, fragmentCreator);
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }
}

