/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.widget.FrameLayout;
import com.intercom.composer.ComposerFragment;
import com.intercom.composer.ComposerHost;
import com.intercom.composer.OnInputSelectedListener;
import com.intercom.composer.input.Input;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.composer.InputDrawableManager;
import io.intercom.android.sdk.conversation.composer.InputProvider;
import io.intercom.android.sdk.conversation.composer.galleryinput.GalleryInputManager;
import io.intercom.android.sdk.conversation.composer.textinput.TextInputManager;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.nexus.NexusClient;
import java.util.Arrays;
import java.util.List;

public class ComposerManager
implements OnInputSelectedListener {
    private static final int SELECT_INPUT_DELAY_MS = 100;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Runnable defaultInputRunnable = new Runnable(){

        @Override
        public void run() {
            ComposerManager.this.composerFragment.selectInput("text_input", true);
        }
    };
    private final FrameLayout composerLayout;
    private final TextInputManager textInputManager;
    private final GalleryInputManager galleryInputManager;
    private final InputDrawableManager inputDrawableManager;
    private final ComposerFragment composerFragment;
    private final MetricsStore metricsStore;
    private final MetricFactory metricFactory;
    private String conversationId;
    private InputProvider inputProvider;

    public ComposerManager(Listener listener, FrameLayout composerLayout, FragmentManager fragmentManager, LayoutInflater inflater, NexusClient nexusClient, UserIdentity userIdentity, AppIdentity appIdentity, MetricsStore metricStore, MetricFactory metricFactory, String conversationId, String initialMessage, Application application, @ColorInt int baseColor) {
        this.composerLayout = composerLayout;
        this.metricsStore = metricStore;
        this.metricFactory = metricFactory;
        this.conversationId = conversationId;
        this.inputDrawableManager = new InputDrawableManager((Context)application, appIdentity.getAppConfig().getBaseColor());
        Fragment fragment = fragmentManager.findFragmentByTag(ComposerFragment.class.getName());
        if (fragment instanceof ComposerFragment) {
            this.composerFragment = (ComposerFragment)fragment;
        } else {
            this.composerFragment = ComposerFragment.newInstance(null, false, baseColor);
            fragmentManager.beginTransaction().replace(R.id.composer_container, (Fragment)this.composerFragment, ComposerFragment.class.getName()).commit();
        }
        this.composerFragment.setComposerHost(new ComposerHost(){

            @Override
            @NonNull
            public List<Input> getInputs() {
                return ComposerManager.this.inputProvider.getInputs();
            }
        });
        this.composerFragment.setOnInputSelectedListener(this);
        this.textInputManager = new TextInputManager((Context)application, inflater, userIdentity, nexusClient, metricStore, metricFactory, conversationId, initialMessage, this.inputDrawableManager, listener);
        this.galleryInputManager = new GalleryInputManager((Context)application, this.inputDrawableManager, listener, metricStore, metricFactory, conversationId);
        this.setUpInputs(fragmentManager);
    }

    private void setUpInputs(FragmentManager fragmentManager) {
        Fragment fragment = fragmentManager.findFragmentByTag(InputProvider.class.getName());
        if (fragment == null) {
            this.inputProvider = new InputProvider();
            this.addInputsToProvider();
            fragmentManager.beginTransaction().add((Fragment)this.inputProvider, InputProvider.class.getName()).commit();
        } else {
            this.inputProvider = (InputProvider)fragment;
            if (this.inputProvider.getInputs().isEmpty()) {
                this.addInputsToProvider();
            }
        }
    }

    private void addInputsToProvider() {
        this.inputProvider.addInputs(Arrays.asList(this.textInputManager.createInput(), this.galleryInputManager.createGifInput(), this.galleryInputManager.createGalleryInput()));
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
        this.textInputManager.setConversationId(conversationId);
        this.galleryInputManager.setConversationId(conversationId);
    }

    public void setHint(@StringRes int hintRes) {
        this.textInputManager.setHint(hintRes);
    }

    public void requestFocus() {
        this.textInputManager.requestFocus();
    }

    public void showComposer() {
        this.composerLayout.setVisibility(0);
    }

    public void hideComposer() {
        this.composerLayout.setVisibility(8);
    }

    public void updateMaxLines() {
        this.textInputManager.updateMaxLines();
    }

    public void cleanup() {
        this.textInputManager.cleanup();
    }

    public void onBackPressed() {
        this.composerFragment.onBackPressed();
    }

    public boolean isOpen() {
        return this.composerFragment.isOpen();
    }

    public void returnToDefaultInput() {
        this.handler.postDelayed(this.defaultInputRunnable, 100L);
    }

    @Override
    public void onInputSelected(Input input) {
        this.metricsStore.track(this.metricFactory.clickedInput(this.conversationId, input.getUniqueIdentifier()));
    }

    public static interface Listener {
        public void onSendButtonPressed(CharSequence var1);

        public void onGalleryImageSelected(GalleryImage var1);
    }
}

