/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.input.gallery;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.Window;
import com.intercom.composer.WindowUtil;
import com.intercom.input.gallery.ClassUtils;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.input.gallery.GalleryLightBoxFragment;
import io.intercom.android.sdk.R;

public class GalleryLightBoxActivity
extends AppCompatActivity
implements View.OnClickListener {
    private static final String KEY_FRAGMENT_CLASS = "fragment_class";
    @VisibleForTesting
    GalleryImage galleryImage;
    @VisibleForTesting
    FragmentManager fragmentManager;
    private Class<? extends GalleryLightBoxFragment> fragmentClass;

    public static Intent createIntent(Context context, GalleryImage galleryImage, Class<? extends GalleryLightBoxFragment> imageLoaderClass) {
        return new Intent(context, GalleryLightBoxActivity.class).putExtra("gallery_image", (Parcelable)galleryImage).putExtra(KEY_FRAGMENT_CLASS, imageLoaderClass);
    }

    protected void onCreate(Bundle bundle) {
        Window window = this.getWindow();
        super.onCreate(bundle);
        this.setContentView(R.layout.intercom_composer_activity_gallery_lightbox);
        WindowUtil.setFullscreenWindow(window, R.color.intercom_composer_status_bar);
        Intent intent = this.getIntent();
        this.galleryImage = (GalleryImage)intent.getParcelableExtra("gallery_image");
        this.fragmentClass = ClassUtils.cast(intent.getSerializableExtra(KEY_FRAGMENT_CLASS));
        this.fragmentManager = this.getSupportFragmentManager();
        if (this.fragmentManager.findFragmentById(R.id.fragment_container) == null) {
            GalleryLightBoxFragment fragment = ClassUtils.instantiate(this.fragmentClass);
            fragment.setArguments(GalleryLightBoxFragment.createArgs(this.galleryImage));
            this.fragmentManager.beginTransaction().replace(R.id.fragment_container, (Fragment)fragment).commit();
        }
        this.findViewById(R.id.send_text).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.dismiss_image).setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.send_text) {
            Intent intent = new Intent();
            intent.putExtra("gallery_image", (Parcelable)this.galleryImage);
            this.setResult(-1, intent);
        }
        this.onBackPressed();
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.overridePendingTransition(R.anim.intercom_composer_stay, R.anim.intercom_composer_slide_down);
    }
}

