/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.composer.keyboard;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.annotation.VisibleForTesting;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import com.intercom.composer.keyboard.OnKeyboardVisibilityListener;
import com.intercom.composer.keyboard.OrientationProvider;
import io.intercom.android.sdk.R;

class KeyboardManager
implements ViewTreeObserver.OnGlobalLayoutListener,
OnKeyboardVisibilityListener {
    private static final String PREFERENCES_NAME = "keyboard";
    private static final String KEY_KEYBOARD_HEIGHT_PORTRAIT = "keyboard_height_portrait";
    private final Window window;
    private final WindowManager windowManager;
    private final InputMethodManager inputMethodManager;
    private final SharedPreferences sharedPreferences;
    private final OrientationProvider orientationProvider;
    @Nullable
    private OnKeyboardVisibilityListener onKeyboardVisibilityListener;
    @VisibleForTesting
    boolean wasOpened;
    @VisibleForTesting
    int previousRelayoutOrientation;

    KeyboardManager(Activity activity, OrientationProvider orientationProvider) {
        this(activity.getWindow(), (WindowManager)activity.getSystemService("window"), (InputMethodManager)activity.getSystemService("input_method"), activity.getSharedPreferences(PREFERENCES_NAME, 0), orientationProvider);
    }

    @VisibleForTesting
    KeyboardManager(Window window, WindowManager windowManager, InputMethodManager inputMethodManager, SharedPreferences sharedPreferences, OrientationProvider orientationProvider) {
        this.window = window;
        this.windowManager = windowManager;
        this.inputMethodManager = inputMethodManager;
        this.sharedPreferences = sharedPreferences;
        this.orientationProvider = orientationProvider;
        this.window.getDecorView().getRootView().getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    void hideSoftInput(View view) {
        this.inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    @Px
    int getKeyboardHeight(int orientation) {
        Resources r = this.window.getContext().getResources();
        if (orientation == 1) {
            int heightPx = r.getDimensionPixelSize(R.dimen.intercom_composer_keyboard_portrait_height);
            return this.sharedPreferences.getInt(KEY_KEYBOARD_HEIGHT_PORTRAIT, heightPx);
        }
        return r.getDimensionPixelSize(R.dimen.intercom_composer_keyboard_landscape_height);
    }

    @Px
    private int getCurrentKeyboardHeight() {
        View decorView = this.window.getDecorView();
        Rect visibleDisplayFrame = new Rect();
        decorView.getWindowVisibleDisplayFrame(visibleDisplayFrame);
        int screenHeight = decorView.getRootView().getHeight();
        int softInputHeight = screenHeight - visibleDisplayFrame.bottom;
        if (Build.VERSION.SDK_INT >= 18) {
            softInputHeight -= this.getSoftButtonsBarHeight();
        }
        return softInputHeight;
    }

    boolean isShowingKeyboard() {
        return this.getCurrentKeyboardHeight() > 0;
    }

    void removeGlobalLayoutListener() {
        if (this.window != null) {
            ViewTreeObserver observer = this.window.getDecorView().getRootView().getViewTreeObserver();
            if (Build.VERSION.SDK_INT >= 16) {
                observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
    }

    @TargetApi(value=18)
    @Px
    private int getSoftButtonsBarHeight() {
        DisplayMetrics metrics = new DisplayMetrics();
        Display defaultDisplay = this.windowManager.getDefaultDisplay();
        defaultDisplay.getMetrics(metrics);
        int usableHeight = metrics.heightPixels;
        defaultDisplay.getRealMetrics(metrics);
        int realHeight = metrics.heightPixels;
        if (realHeight > usableHeight) {
            return realHeight - usableHeight;
        }
        return 0;
    }

    void setOnKeyboardVisibilityListener(@Nullable OnKeyboardVisibilityListener onKeyboardVisibilityListener) {
        this.onKeyboardVisibilityListener = onKeyboardVisibilityListener;
    }

    public void onGlobalLayout() {
        int keyboardHeight = this.getCurrentKeyboardHeight();
        boolean isOpen = keyboardHeight > 0;
        int currentOrientation = this.orientationProvider.getOrientation();
        if (isOpen == this.wasOpened && currentOrientation == this.previousRelayoutOrientation) {
            return;
        }
        this.wasOpened = isOpen;
        this.previousRelayoutOrientation = currentOrientation;
        this.onKeyboardVisibilityChanged(isOpen, keyboardHeight);
        if (this.onKeyboardVisibilityListener != null) {
            this.onKeyboardVisibilityListener.onKeyboardVisibilityChanged(isOpen, keyboardHeight);
        }
    }

    @Override
    public void onKeyboardVisibilityChanged(boolean visible, @Px int height) {
        if (visible && this.orientationProvider.getOrientation() == 1) {
            this.sharedPreferences.edit().putInt(KEY_KEYBOARD_HEIGHT_PORTRAIT, height).apply();
        }
    }
}

