/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.composer.animation;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Property;
import android.view.View;
import android.widget.ImageView;
import com.intercom.composer.animation.AnimationStatus;
import com.intercom.composer.animation.HideSendButtonAnimatorListener;
import com.intercom.composer.animation.ShowSendButtonAnimatorListener;

public class SendButtonAnimator {
    private static final long SEND_BUTTON_ANIMATION_MS = 100L;
    private static final String ALPHA = "alpha";
    @VisibleForTesting
    final View background;
    @VisibleForTesting
    final ImageView button;
    private final ShowSendButtonAnimatorListener showSendButtonAnimatorListener;
    private final HideSendButtonAnimatorListener hideSendButtonAnimatorListener;
    private ObjectAnimator showSendAnimator;
    private ObjectAnimator hideSendAnimator;
    @Nullable
    @VisibleForTesting
    AnimatorSet animatorSet;
    @VisibleForTesting
    final ValueAnimator.AnimatorUpdateListener backgroundListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            SendButtonAnimator.this.background.setAlpha(((Float)animation.getAnimatedValue()).floatValue());
        }
    };

    public SendButtonAnimator(View background, ImageView button, ShowSendButtonAnimatorListener showSendButtonAnimatorListener, HideSendButtonAnimatorListener hideSendButtonAnimatorListener) {
        this.background = background;
        this.button = button;
        this.showSendButtonAnimatorListener = showSendButtonAnimatorListener;
        this.hideSendButtonAnimatorListener = hideSendButtonAnimatorListener;
        this.showSendAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)button, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}), PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.6f, 1.0f}), PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.6f, 1.0f})});
        this.showSendAnimator.setStartDelay(50L);
        this.hideSendAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)button, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}), PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 0.6f}), PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 0.6f})});
    }

    public void animateButtonVisibility(boolean show, AnimationStatus animationStatus) {
        boolean shouldShowSendButton;
        if (show && (animationStatus == AnimationStatus.HIDING || animationStatus == AnimationStatus.HIDDEN || animationStatus == AnimationStatus.UNKNOWN)) {
            shouldShowSendButton = true;
        } else if (!(show || animationStatus != AnimationStatus.SHOWING && animationStatus != AnimationStatus.SHOWN && animationStatus != AnimationStatus.UNKNOWN)) {
            shouldShowSendButton = false;
        } else {
            return;
        }
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
        }
        this.animatorSet = new AnimatorSet();
        float targetAlpha = shouldShowSendButton ? 1.0f : 0.0f;
        ObjectAnimator backgroundAnimator = ObjectAnimator.ofFloat((Object)this.background, (String)ALPHA, (float[])new float[]{targetAlpha});
        backgroundAnimator.addUpdateListener(this.backgroundListener);
        this.animatorSet.playTogether(new Animator[]{backgroundAnimator, shouldShowSendButton ? this.showSendAnimator : this.hideSendAnimator});
        this.animatorSet.setDuration(100L);
        this.animatorSet.addListener((Animator.AnimatorListener)(show ? this.showSendButtonAnimatorListener : this.hideSendButtonAnimatorListener));
        this.animatorSet.start();
    }
}

