/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.composer;

import android.app.Activity;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.intercom.composer.ComposerAnimationStateListener;
import com.intercom.composer.OnInputSelectedListener;
import com.intercom.composer.animation.AnimationStatus;
import com.intercom.composer.animation.EditTextLayoutAnimator;
import com.intercom.composer.animation.EditTextLayoutAnimatorInternalListener;
import com.intercom.composer.animation.HideSendButtonAnimatorListener;
import com.intercom.composer.animation.SendButtonAnimator;
import com.intercom.composer.animation.ShowSendButtonAnimatorListener;
import com.intercom.composer.input.Input;
import com.intercom.composer.input.iconbar.InputClickedListener;
import com.intercom.composer.input.iconbar.InputIconRecyclerDecoration;
import com.intercom.composer.input.iconbar.InputIconsRecyclerAdapter;
import com.intercom.composer.input.iconbar.InputSelectedListener;
import com.intercom.composer.input.text.TextInput;
import com.intercom.composer.input.text.listener.OnSendButtonClickedListener;
import com.intercom.composer.input.text.listener.SendButtonClickListener;
import com.intercom.composer.input.text.options.InputOptionImageViewClickListener;
import com.intercom.composer.input.text.options.TextInputOption;
import com.intercom.composer.keyboard.KeyboardHelper;
import com.intercom.composer.keyboard.OrientationProvider;
import com.intercom.composer.pager.ComposerPagerAdapter;
import com.intercom.composer.watcher.OnSendButtonStateChangedListener;
import com.intercom.composer.watcher.SendButtonTextWatcher;
import io.intercom.android.sdk.R;
import java.util.ArrayList;
import java.util.List;

public class ComposerView
extends LinearLayout
implements OnSendButtonStateChangedListener,
OnSendButtonClickedListener,
InputSelectedListener,
InputClickedListener,
ComposerAnimationStateListener {
    @VisibleForTesting
    RecyclerView inputIconsRecyclerView;
    @VisibleForTesting
    LinearLayout editTextLayout;
    @VisibleForTesting
    ViewPager viewPager;
    @VisibleForTesting
    ImageView sendButton;
    @VisibleForTesting
    View sendButtonFadingBackground;
    @VisibleForTesting
    View composerUpperBorder;
    @VisibleForTesting
    View composerLowerBorder;
    private final List<Input> inputs = new ArrayList<Input>();
    @VisibleForTesting
    InputIconsRecyclerAdapter inputIconsRecyclerAdapter;
    private final LinearLayoutManager layoutManager;
    @VisibleForTesting
    KeyboardHelper keyboardHelper;
    @VisibleForTesting
    EditTextLayoutAnimator editTextLayoutAnimator;
    private final OrientationProvider orientationProvider;
    @Nullable
    private OnSendButtonClickedListener onSendButtonClickListener;
    @Nullable
    @VisibleForTesting
    OnInputSelectedListener inputSelectedListener;
    @Nullable
    @VisibleForTesting
    SendButtonAnimator sendButtonAnimator;
    @VisibleForTesting
    AnimationStatus sendButtonAnimationStatus = AnimationStatus.UNKNOWN;
    @VisibleForTesting
    final SendButtonTextWatcher sendButtonTextWatcher;

    public ComposerView(Context context) {
        this(context, null);
    }

    public ComposerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ComposerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        ComposerView.inflate((Context)context, (int)R.layout.intercom_composer_view_layout, (ViewGroup)this);
        this.composerUpperBorder = this.findViewById(R.id.composer_upper_border);
        this.composerLowerBorder = this.findViewById(R.id.composer_lower_border);
        this.editTextLayout = (LinearLayout)this.findViewById(R.id.composer_edit_text_layout);
        this.inputIconsRecyclerView = (RecyclerView)this.findViewById(R.id.composer_input_icons_recycler_view);
        this.viewPager = (ViewPager)this.findViewById(R.id.composer_view_pager);
        this.sendButton = (ImageView)this.findViewById(R.id.send_button);
        this.sendButtonFadingBackground = this.findViewById(R.id.send_button_fading_background);
        this.orientationProvider = new OrientationProvider(context);
        this.keyboardHelper = new KeyboardHelper((Activity)context, this.orientationProvider, (View)this.editTextLayout, (View)this.viewPager);
        this.editTextLayoutAnimator = new EditTextLayoutAnimator((View)this.editTextLayout);
        this.layoutManager = new LinearLayoutManager(context, 0, false);
        this.inputIconsRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.inputIconsRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new InputIconRecyclerDecoration(context));
        this.sendButtonTextWatcher = new SendButtonTextWatcher(this);
    }

    void applyTheme(Context context, @ColorInt int color2) {
        Drawable sendBackground = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_composer_send_background);
        sendBackground.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        if (Build.VERSION.SDK_INT >= 16) {
            this.sendButton.setBackground(sendBackground);
        } else {
            this.sendButton.setBackgroundDrawable(sendBackground);
        }
    }

    @Override
    public void onInputClicked(RecyclerView.ViewHolder viewHolder) {
        int adapterPosition = viewHolder.getAdapterPosition();
        if (adapterPosition >= 0 && adapterPosition < this.inputs.size()) {
            this.selectInput(this.inputs.get(adapterPosition), true, true);
        }
    }

    @Override
    public void onInputSelected(Input newInput, int position, boolean showKeyboard, boolean animateEditText) {
        if (newInput instanceof TextInput) {
            EditText newEditText = this.replaceEditText((TextInput)newInput);
            this.editTextLayoutAnimator.showEditText(animateEditText);
            if (showKeyboard) {
                this.showKeyboard(newEditText);
            }
            this.animateSendButtonVisibility(!TextUtils.isEmpty((CharSequence)newEditText.getText()));
        } else {
            this.keyboardHelper.showBehindKeyboardView();
            this.editTextLayout.clearFocus();
            this.editTextLayoutAnimator.hideEditText();
            this.animateSendButtonVisibility(false);
        }
        this.updateColors(newInput.getBackgroundColor(), newInput.getBorderColor());
        this.viewPager.setCurrentItem(position, false);
    }

    @Override
    public void onAnimationStateChanged(AnimationStatus animationStatus) {
        this.sendButtonAnimationStatus = animationStatus;
    }

    @Override
    public void setSendButtonVisibility(int visibility) {
        this.sendButton.setVisibility(visibility);
    }

    @Override
    public void animateSendButtonVisibility(boolean visible) {
        if (this.sendButtonAnimator != null) {
            this.sendButtonAnimator.animateButtonVisibility(visible, this.sendButtonAnimationStatus);
        }
    }

    @Override
    public void onSendButtonClicked(CharSequence textToBeSent) {
        if (this.onSendButtonClickListener != null) {
            this.onSendButtonClickListener.onSendButtonClicked(textToBeSent);
        }
    }

    public void setOnSendButtonClickListener(@NonNull OnSendButtonClickedListener onSendButtonClickListener) {
        this.onSendButtonClickListener = onSendButtonClickListener;
    }

    public void setInputSelectedListener(@NonNull OnInputSelectedListener inputSelectedListener) {
        this.inputSelectedListener = inputSelectedListener;
    }

    public void setEditTextLayoutAnimationListener(EditTextLayoutAnimatorInternalListener editTextAnimatorListener) {
        this.editTextLayoutAnimator.setEditTextLayoutAnimatorListener(editTextAnimatorListener);
    }

    public void setFragmentManager(FragmentManager fragmentManager) {
        this.inputIconsRecyclerAdapter = new InputIconsRecyclerAdapter(LayoutInflater.from((Context)this.getContext()), this.inputs, this, this, fragmentManager);
        this.inputIconsRecyclerView.setAdapter((RecyclerView.Adapter)this.inputIconsRecyclerAdapter);
    }

    public void setComposerPagerAdapter(@NonNull ComposerPagerAdapter composerPagerAdapter) {
        this.viewPager.setAdapter((PagerAdapter)composerPagerAdapter);
        this.viewPager.setOffscreenPageLimit(this.inputs.size());
        ShowSendButtonAnimatorListener showButtonListener = new ShowSendButtonAnimatorListener(this.inputs, composerPagerAdapter, this.inputIconsRecyclerAdapter, this.layoutManager, this);
        HideSendButtonAnimatorListener hideButtonListener = new HideSendButtonAnimatorListener(this.inputs, composerPagerAdapter, this.inputIconsRecyclerAdapter, this);
        this.sendButtonAnimator = new SendButtonAnimator(this.sendButtonFadingBackground, this.sendButton, showButtonListener, hideButtonListener);
    }

    public void setInputs(List<? extends Input> inputs) {
        if (this.inputIconsRecyclerAdapter == null) {
            throw new IllegalStateException("Fragment manager should be set!");
        }
        this.inputs.clear();
        this.inputs.addAll(inputs);
        this.setupTextInputs();
        this.inputIconsRecyclerAdapter.notifyDataSetChanged();
    }

    public void updateColors(@ColorRes int backgroundColorRes, @ColorRes int borderColorRes) {
        this.editTextLayout.setBackgroundResource(backgroundColorRes);
        this.inputIconsRecyclerView.setBackgroundResource(backgroundColorRes);
        this.sendButtonFadingBackground.setBackgroundResource(backgroundColorRes);
        this.composerUpperBorder.setBackgroundResource(borderColorRes);
        this.composerLowerBorder.setBackgroundResource(borderColorRes);
    }

    public boolean selectInput(Input input, boolean showKeyboard, boolean animateEditText) {
        if (this.inputSelectedListener != null) {
            this.inputSelectedListener.onInputSelected(input);
        }
        return this.inputIconsRecyclerAdapter.selectInput(input, showKeyboard, animateEditText);
    }

    public boolean onBackPressed() {
        Input selectedInput = this.getSelectedInput();
        if (selectedInput != null && !selectedInput.equals(this.inputs.get(0))) {
            this.selectInput(this.inputs.get(0), false, false);
        } else {
            this.inputIconsRecyclerAdapter.deselectAllInputs();
        }
        return this.keyboardHelper.hideBehindKeyboardView();
    }

    public void onDestroy() {
        this.removeTextWatcher();
        this.keyboardHelper.onDestroy();
    }

    @VisibleForTesting
    void removeTextWatcher() {
        int childCount = this.editTextLayout.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.editTextLayout.getChildAt(i);
                if (!(child instanceof EditText)) continue;
                ((EditText)child).removeTextChangedListener((TextWatcher)this.sendButtonTextWatcher);
            }
        }
    }

    private void setupTextInputs() {
        if (this.editTextNeededBySomeInput()) {
            this.editTextLayout.setVisibility(0);
            this.sendButton.setVisibility(0);
            this.sendButtonFadingBackground.setVisibility(0);
        } else {
            this.editTextLayout.setVisibility(8);
            this.sendButton.setVisibility(8);
            this.sendButtonFadingBackground.setVisibility(8);
        }
    }

    private boolean editTextNeededBySomeInput() {
        for (Input input : this.inputs) {
            if (!(input instanceof TextInput)) continue;
            return true;
        }
        return false;
    }

    private void showKeyboard(EditText editText) {
        editText.requestFocus();
        InputMethodManager inputMethodManager = (InputMethodManager)editText.getContext().getSystemService("input_method");
        inputMethodManager.showSoftInput((View)editText, 0);
        boolean fullScreenKeyboard = editText.getContext().getResources().getBoolean(R.bool.intercom_composer_keyboard_takes_full_screen_in_landscape);
        if (fullScreenKeyboard && this.orientationProvider.getOrientation() == 2) {
            this.keyboardHelper.hideBehindKeyboardView();
        }
    }

    EditText replaceEditText(TextInput selectedInput) {
        EditText inputEditText = selectedInput.getEditText();
        List<TextInputOption> options = selectedInput.getOptions();
        this.editTextLayout.removeAllViews();
        this.removeViewFromParent((View)inputEditText);
        LinearLayout.LayoutParams param = new LinearLayout.LayoutParams(0, -2, 1.0f);
        this.editTextLayout.addView((View)inputEditText, (ViewGroup.LayoutParams)param);
        this.sendButton.setOnClickListener((View.OnClickListener)new SendButtonClickListener(this, inputEditText));
        inputEditText.addTextChangedListener((TextWatcher)this.sendButtonTextWatcher);
        this.animateSendButtonVisibility(!TextUtils.isEmpty((CharSequence)inputEditText.getText()));
        if (options != null) {
            for (TextInputOption option : options) {
                int paddingInPixel = this.getResources().getDimensionPixelSize(R.dimen.intercom_composer_editable_text_input_option_padding);
                int paddingInPixelBottom = this.getResources().getDimensionPixelSize(R.dimen.intercom_composer_editable_text_input_option_padding_bottom);
                ImageView imageView = new ImageView(this.getContext());
                imageView.setImageResource(option.getResourceId());
                imageView.setPadding(paddingInPixel, paddingInPixel, paddingInPixel, paddingInPixelBottom);
                imageView.setOnClickListener((View.OnClickListener)new InputOptionImageViewClickListener(option));
                this.editTextLayout.addView((View)imageView);
            }
        }
        return inputEditText;
    }

    private void removeViewFromParent(View view) {
        ViewParent parent = view.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView(view);
        }
    }

    public Input getSelectedInput() {
        return this.inputIconsRecyclerAdapter.getSelectedInput();
    }

    public int getTextInputHeight() {
        return this.editTextLayout.getHeight();
    }
}

