/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.conversation.ConversationFragment;
import io.intercom.android.sdk.inbox.ConversationsListFragment;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.events.CloseMessengerEvent;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.android.sdk.views.StatusBarThemer;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringListener;
import io.intercom.com.squareup.otto.Subscribe;

public class IntercomMessengerActivity
extends IntercomBaseActivity
implements ConversationsListFragment.Listener,
ConversationFragment.Listener,
View.OnClickListener {
    private static final int SPRING_TENSION = 600;
    private static final int SPRING_FRICTION = 40;
    @VisibleForTesting
    protected static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    @VisibleForTesting
    ValueAnimator colorAnimation;
    static final String SHOW_INBOX = "showInbox";
    static final String LAST_PARTICIPANT = "last_participant";
    private ConversationsListFragment inbox;
    private View containerView;
    private View background;
    private Spring spring;
    private boolean isTwoPane;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_messenger_activity_layout);
        this.isTwoPane = this.getResources().getBoolean(R.bool.intercom_is_two_pane);
        this.inbox = ConversationsListFragment.newInstance(this.isTwoPane);
        this.setUpSpringSystem();
        this.containerView = this.findViewById(R.id.messenger_container);
        if (this.containerView != null) {
            this.containerView.setVisibility(8);
        }
        Injector.init(this.getApplication());
        this.getFragmentManager().executePendingTransactions();
        this.showMessenger();
        Injector.get().getBus().register((Object)this);
    }

    private int getScreenHeight() {
        return this.findViewById(0x1020002).getMeasuredHeight();
    }

    protected void onDestroy() {
        Injector.get().getBus().unregister((Object)this);
        super.onDestroy();
    }

    private void showMessenger() {
        Bundle data = this.getIntent().getExtras();
        String conversationId = "";
        LastParticipatingAdmin lastParticipatingAdmin = LastParticipatingAdmin.NULL;
        boolean shouldShowInbox = false;
        if (data != null) {
            if (data.containsKey(PARCEL_CONVERSATION_ID)) {
                conversationId = data.getString(PARCEL_CONVERSATION_ID);
            }
            if (data.containsKey(SHOW_INBOX)) {
                shouldShowInbox = data.getBoolean(SHOW_INBOX);
            }
            if (data.containsKey(LAST_PARTICIPANT)) {
                lastParticipatingAdmin = (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT);
            }
        }
        if (this.isTwoPane) {
            if (shouldShowInbox) {
                this.inbox.setShouldOpenFirstConversation(true);
            } else {
                this.displayConversationFragment(conversationId, lastParticipatingAdmin);
            }
            this.displayInboxFragment();
        } else if (shouldShowInbox) {
            this.displayInboxFragment();
        } else {
            this.displayConversationFragment(conversationId, lastParticipatingAdmin);
        }
        this.background = this.getWindow().getDecorView();
        BackgroundUtils.animateBackground(ContextCompat.getColor((Context)this, (int)17170445), ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black), 200, this.background, new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.background.post(new Runnable(){

                    @Override
                    public void run() {
                        IntercomMessengerActivity.this.animateSdkWindowIn();
                    }
                });
            }
        });
    }

    private void setUpSpringSystem() {
        this.spring = Injector.get().getSpringProvider().newSpringSystem().createSpring();
        this.spring.setSpringConfig(new SpringConfig(600.0, 40.0));
    }

    private void displayFragment(Fragment frag, String tag, boolean addToBackStack) {
        IntercomLogger.internal("frag", "displaying " + frag);
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        int fragmentId = frag instanceof ConversationFragment && this.isTwoPane ? R.id.conversation_fragment : R.id.inbox_fragment;
        transaction.replace(fragmentId, frag, tag);
        if (addToBackStack) {
            IntercomLogger.internal("frag", "adding " + frag + " to the back stack");
            transaction.addToBackStack(tag);
        }
        transaction.commit();
    }

    private void displayInboxFragment() {
        this.displayFragment(this.inbox, ConversationsListFragment.class.getName(), false);
    }

    private void displayConversationFragment(String conversationId, LastParticipatingAdmin lastParticipatingAdmin) {
        this.loadConversation(conversationId, lastParticipatingAdmin, false, false);
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 0) {
            Injector.get().getMetricsStore().track(MetricFactory.closedMessengerBackButton());
            this.closeMessenger();
        } else {
            this.trackMoveToConversationListMetric();
            super.onBackPressed();
        }
    }

    private void trackMoveToConversationListMetric() {
        ConversationFragment fragment = (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag(ConversationFragment.class.getName());
        if (fragment != null) {
            String conversationId = fragment.getConversationId();
            if (TextUtils.isEmpty((CharSequence)conversationId)) {
                Injector.get().getMetricsStore().track(MetricFactory.openConversationsListFromNewConversation());
            } else {
                Injector.get().getMetricsStore().track(MetricFactory.openConversationsListFromConversation(conversationId));
            }
        }
    }

    @Override
    public void loadConversation(String conversationId, LastParticipatingAdmin participant, boolean isRead, boolean addToBackStack) {
        this.displayFragment(ConversationFragment.newInstance(conversationId, participant, isRead, this.isTwoPane), ConversationFragment.class.getName(), addToBackStack);
    }

    @Override
    public void showErrorMessageDialog() {
        new AlertDialog.Builder((Context)this).setTitle(R.string.intercom_inbox_error_state_title).setMessage(R.string.intercom_message_error_message).setPositiveButton(R.string.intercom_tap_to_retry, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ConversationFragment fragment = (ConversationFragment)IntercomMessengerActivity.this.getSupportFragmentManager().findFragmentByTag(ConversationFragment.class.getName());
                if (fragment != null) {
                    fragment.retryTapped();
                }
            }
        }).show();
    }

    private void animateSdkWindowIn() {
        this.spring.removeAllListeners();
        this.spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringAtRest(Spring spring) {
                IntercomMessengerActivity.this.hideBackgroundColor();
                ConversationFragment fragment = (ConversationFragment)IntercomMessengerActivity.this.getSupportFragmentManager().findFragmentByTag(ConversationFragment.class.getName());
                if (fragment != null) {
                    fragment.sdkWindowFinishedAnimating();
                }
            }

            public void onSpringActivate(Spring spring) {
                IntercomMessengerActivity.this.containerView.setVisibility(0);
            }

            public void onSpringUpdate(Spring spring) {
                IntercomMessengerActivity.this.containerView.setY((float)spring.getCurrentValue());
            }
        });
        this.spring.setCurrentValue((double)this.getScreenHeight());
        this.spring.setEndValue(0.0);
        this.spring.setRestDisplacementThreshold(2.0);
    }

    private void closeMessenger() {
        this.hideKeyboard();
        this.animateSdkWindowOut();
        this.fadeOutBackground();
    }

    private void hideKeyboard() {
        View focusedView = this.getCurrentFocus();
        if (focusedView != null) {
            InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
        }
    }

    private void animateSdkWindowOut() {
        this.showBackgroundColour();
        this.spring.removeAllListeners();
        this.spring.setCurrentValue((double)this.containerView.getY());
        this.spring.setEndValue((double)this.getWindow().getDecorView().getHeight());
        this.spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                float value = (float)spring.getCurrentValue();
                IntercomMessengerActivity.this.containerView.setY(value);
            }
        });
    }

    private void fadeOutBackground() {
        int colorTo = ContextCompat.getColor((Context)this, (int)17170445);
        int colorFrom = ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black);
        this.colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        this.colorAnimation.setDuration(300L);
        this.colorAnimation.setStartDelay(100L);
        this.colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator2) {
                IntercomMessengerActivity.this.background.setBackgroundColor(((Integer)animator2.getAnimatedValue()).intValue());
            }
        });
        this.colorAnimation.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.finish();
                IntercomMessengerActivity.this.overridePendingTransition(0, 0);
            }
        });
        this.colorAnimation.start();
    }

    @Override
    public void onToolbarCloseClicked() {
        Injector.get().getMetricsStore().track(MetricFactory.closedMessengerCloseButton());
        this.closeMessenger();
    }

    @Override
    public void onBackToInboxClicked() {
        if (this.hasLoadedFragment(ConversationsListFragment.class.getName())) {
            this.onBackPressed();
        } else {
            this.trackMoveToConversationListMetric();
            this.displayFragment(this.inbox, ConversationsListFragment.class.getName(), false);
        }
    }

    private void showBackgroundColour() {
        this.background.setBackgroundResource(R.color.intercom_transparent_black);
    }

    private void hideBackgroundColor() {
        this.background.setBackgroundResource(R.color.intercom_full_transparent_full_black);
    }

    @Override
    public void setStatusBarColor() {
        StatusBarThemer.setStatusBarColor(this.getWindow());
    }

    public static Intent openInbox(Context context) {
        return new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, true);
    }

    public static Intent openComposer(Context context) {
        return new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, false);
    }

    public static Intent openConversation(Context context, String conversationId, LastParticipatingAdmin lastParticipatingAdmin) {
        Intent intent = new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, false);
        if (!TextUtils.isEmpty((CharSequence)conversationId)) {
            intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        }
        if (!LastParticipatingAdmin.isNull(lastParticipatingAdmin)) {
            intent.putExtra(LAST_PARTICIPANT, (Parcelable)lastParticipatingAdmin);
        }
        return intent;
    }

    @Subscribe
    public void closeSdk(CloseMessengerEvent event) {
        this.finish();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.containerView.setY(0.0f);
        this.containerView.getLayoutParams().height = -1;
    }

    public void onClick(View v) {
        ConversationFragment fragment = (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag(ConversationFragment.class.getName());
        if (fragment != null) {
            fragment.toggleProfile();
        }
    }

    private boolean hasLoadedFragment(String fragmentTag) {
        return this.getSupportFragmentManager().findFragmentByTag(fragmentTag) != null;
    }
}

