/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.Conversation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConversationList
implements Parcelable {
    private final List<Conversation> conversations;
    private final Set<String> unreadConversationIds;
    private final boolean morePagesAvailable;
    private final int totalUnreadCount;
    public static final Parcelable.Creator<ConversationList> CREATOR = new Parcelable.Creator<ConversationList>(){

        public ConversationList createFromParcel(Parcel in) {
            return new ConversationList(in);
        }

        public ConversationList[] newArray(int size) {
            return new ConversationList[size];
        }
    };

    public ConversationList() {
        this(new Builder());
    }

    private ConversationList(Builder builder) {
        this.conversations = new ArrayList<Conversation>(CollectionUtils.capacityFor((Collection)builder.conversations));
        if (builder.conversations != null) {
            for (Conversation.Builder conversationBuilder : builder.conversations) {
                this.conversations.add(conversationBuilder.build());
            }
        }
        this.unreadConversationIds = new HashSet<String>(CollectionUtils.capacityFor((Collection)builder.unread_conversation_ids));
        if (builder.unread_conversation_ids != null) {
            for (String id2 : builder.unread_conversation_ids) {
                if (id2 == null) continue;
                this.unreadConversationIds.add(id2);
            }
        }
        this.totalUnreadCount = builder.unread_conversation_ids == null ? builder.total_unread_count : builder.unread_conversation_ids.size();
        this.morePagesAvailable = builder.more_pages_available;
    }

    public List<Conversation> getConversations() {
        return this.conversations;
    }

    public Set<String> getUnreadConversationIds() {
        return this.unreadConversationIds;
    }

    public int getTotalUnreadCount() {
        return this.totalUnreadCount;
    }

    public boolean hasMorePages() {
        return this.morePagesAvailable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationList that = (ConversationList)o;
        if (this.morePagesAvailable != that.morePagesAvailable) {
            return false;
        }
        if (this.totalUnreadCount != that.totalUnreadCount) {
            return false;
        }
        if (!this.conversations.equals(that.conversations)) {
            return false;
        }
        return this.unreadConversationIds.equals(that.unreadConversationIds);
    }

    public int hashCode() {
        int result = this.conversations.hashCode();
        result = 31 * result + this.unreadConversationIds.hashCode();
        result = 31 * result + (this.morePagesAvailable ? 1 : 0);
        result = 31 * result + this.totalUnreadCount;
        return result;
    }

    private ConversationList(Parcel in) {
        this.totalUnreadCount = in.readInt();
        this.conversations = new ArrayList<Conversation>();
        if (in.readByte() == 1) {
            in.readList(this.conversations, Conversation.class.getClassLoader());
        }
        this.morePagesAvailable = in.readByte() != 0;
        ArrayList unreadConversationIds = new ArrayList();
        if (in.readByte() == 1) {
            in.readList(unreadConversationIds, Conversation.class.getClassLoader());
        }
        this.unreadConversationIds = new HashSet<String>(unreadConversationIds);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.totalUnreadCount);
        if (this.conversations == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.conversations);
        }
        dest.writeByte((byte)(this.morePagesAvailable ? 1 : 0));
        if (this.unreadConversationIds == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            ArrayList<String> unreadConversationIds = new ArrayList<String>(this.unreadConversationIds);
            dest.writeList(unreadConversationIds);
        }
    }

    public static final class Builder {
        private List<Conversation.Builder> conversations;
        private List<String> unread_conversation_ids;
        private boolean more_pages_available;
        private int total_unread_count;

        public ConversationList build() {
            return new ConversationList(this);
        }
    }
}

