/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;

class DefaultLauncher
implements View.OnTouchListener {
    private final TextView badgeCount;
    private final View launcherRoot;
    private final Listener listener;
    private final View badge;

    public DefaultLauncher(ViewGroup root, LayoutInflater inflater, AppConfig.Provider appConfigProvider, Listener listener) {
        this.listener = listener;
        inflater.inflate(R.layout.intercom_default_launcher, root, true);
        this.launcherRoot = root.findViewById(R.id.launcher_root);
        this.badge = this.launcherRoot.findViewById(R.id.launcher_icon);
        this.badgeCount = (TextView)this.launcherRoot.findViewById(R.id.launcher_badge_count);
        this.updateBackgrounds(appConfigProvider);
        this.launcherRoot.setOnTouchListener((View.OnTouchListener)this);
    }

    public void updateBackgrounds(AppConfig.Provider appConfigProvider) {
        Context context = this.badge.getContext();
        Drawable iconBg = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_solid_circle);
        iconBg.setColorFilter(appConfigProvider.getAppConfig().getBaseColor(), PorterDuff.Mode.SRC_IN);
        Drawable countBg = iconBg.getConstantState().newDrawable();
        int countBackgroundColour = ContextCompat.getColor((Context)context, (int)R.color.intercom_inbox_count_background);
        countBg.setColorFilter(countBackgroundColour, PorterDuff.Mode.SRC_IN);
        BackgroundUtils.setBackground((View)this.badgeCount, countBg);
        BackgroundUtils.setBackground(this.badge, iconBg);
    }

    public void setBadgeCount(String unreadCount) {
        this.badgeCount.setVisibility(0);
        this.badgeCount.setText((CharSequence)unreadCount);
    }

    public void hideBadgeCount() {
        this.badgeCount.setVisibility(8);
    }

    public void fadeOnScreen() {
        this.launcherRoot.setAlpha(0.0f);
        this.launcherRoot.animate().alpha(1.0f).setDuration(100L).start();
    }

    public void fadeOffScreen() {
        this.fadeOffScreen(null);
    }

    public void fadeOffScreen(@Nullable Animator.AnimatorListener listener) {
        this.launcherRoot.animate().alpha(0.0f).setDuration(100L).setListener(listener).start();
    }

    public void pulseForTransformation(final Animator.AnimatorListener listener) {
        this.launcherRoot.animate().scaleX(1.1f).scaleY(1.1f).setDuration(100L).setListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                listener.onAnimationEnd(animation);
                DefaultLauncher.this.launcherRoot.animate().scaleX(1.0f).scaleY(1.0f).setDuration(100L).start();
            }
        }).start();
    }

    public void removeView() {
        if (this.launcherRoot.getParent() != null) {
            ((ViewGroup)this.launcherRoot.getParent()).removeView(this.launcherRoot);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                v.setScaleX(0.9f);
                v.setScaleY(0.9f);
                break;
            }
            case 1: {
                this.callListenerWithFadeOut();
                break;
            }
        }
        return true;
    }

    private void callListenerWithFadeOut() {
        ObjectAnimator fadeOut = ObjectAnimator.ofFloat((Object)this.launcherRoot, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(50L);
        fadeOut.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                DefaultLauncher.this.listener.onLauncherClicked(DefaultLauncher.this.launcherRoot.getContext());
            }
        });
        fadeOut.start();
    }

    public static interface Listener {
        public void onLauncherClicked(Context var1);
    }
}

