/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.intercom.android.sdk.utilities.TimeProvider;
import io.intercom.com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class MetricObject {
    private static final String METRIC_NAME = "mv3_metric";
    private static final String KEY_ANDROID_INSTALLER_PACKAGE_NAME = "android_installer_package_name";
    private static final String KEY_ANDROID_IS_DEBUG_BUILD = "android_is_debug_build";
    static final String KEY_USER_ID = "user_id";
    static final String KEY_ACTION = "action";
    static final String KEY_OBJECT = "object";
    static final String KEY_PLACE = "place";
    static final String KEY_CONTEXT = "context";
    private final Map<String, Object> metadata = new HashMap<String, Object>();
    private final String id;
    @SerializedName(value="created_at")
    private final long createdAt;
    private final String name = "mv3_metric";

    MetricObject(String intercomId, String action, String object, String place, String context, TimeProvider timeProvider) {
        this.createdAt = TimeUnit.MILLISECONDS.toSeconds(timeProvider.currentTimeMillis());
        this.id = UUID.randomUUID().toString();
        this.metadata.put(KEY_ACTION, action);
        this.metadata.put(KEY_OBJECT, object);
        this.metadata.put(KEY_PLACE, place);
        this.metadata.put(KEY_CONTEXT, context);
        if (!TextUtils.isEmpty((CharSequence)intercomId)) {
            this.metadata.put(KEY_USER_ID, intercomId);
        }
    }

    MetricObject addMetaData(String key, Object value) {
        this.metadata.put(key, value);
        return this;
    }

    MetricObject addIsDebugBuild(boolean isDebugBuild) {
        this.addMetaData(KEY_ANDROID_IS_DEBUG_BUILD, isDebugBuild);
        return this;
    }

    MetricObject addInstallerPackageName(@Nullable String installerPackageName) {
        if (TextUtils.isEmpty((CharSequence)installerPackageName)) {
            installerPackageName = "unknown";
        }
        this.addMetaData(KEY_ANDROID_INSTALLER_PACKAGE_NAME, installerPackageName);
        return this;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricObject that = (MetricObject)o;
        if (this.createdAt != that.createdAt) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return METRIC_NAME != null ? METRIC_NAME.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.metadata != null ? this.metadata.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (METRIC_NAME != null ? METRIC_NAME.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        return result;
    }

    public String toString() {
        return "MetricObject{metadata=" + this.metadata + ", id='" + this.id + '\'' + ", name='" + METRIC_NAME + '\'' + ", createdAt=" + this.createdAt + '}';
    }
}

