/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.views.AdminIsTypingView;
import io.intercom.android.sdk.views.ExpandableLayout;
import io.intercom.android.sdk.views.holder.ConversationListener;
import io.intercom.android.sdk.views.holder.ConversationPartViewHolder;

abstract class BlocksPartViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener,
ConversationPartViewHolder {
    protected final ConversationListener conversationListener;
    @Nullable
    private final ClipboardManager clipboardManager;
    protected final ImageView networkAvatar;
    protected final LinearLayout cellLayout;
    @Nullable
    protected final ExpandableLayout bubble;
    private final String clipboardMessage;

    public BlocksPartViewHolder(View itemView, ConversationListener conversationListener, @Nullable ClipboardManager clipboardManager) {
        super(itemView);
        this.conversationListener = conversationListener;
        this.clipboardManager = clipboardManager;
        this.clipboardMessage = itemView.getContext().getString(R.string.intercom_clipboard_message);
        this.networkAvatar = (ImageView)itemView.findViewById(R.id.avatarView);
        this.cellLayout = (LinearLayout)itemView.findViewById(R.id.cellLayout);
        this.bubble = (ExpandableLayout)itemView.findViewById(R.id.intercom_bubble);
        itemView.setOnClickListener((View.OnClickListener)this);
        itemView.setOnLongClickListener((View.OnLongClickListener)this);
    }

    protected ViewGroup setUpHolderBlocks(Part conversationPart, LinearLayout cellLayout, ExpandableLayout bubble, ViewGroup blocksLayout) {
        cellLayout.setVisibility(0);
        if (blocksLayout.getParent() != null) {
            ((ViewGroup)blocksLayout.getParent()).removeView((View)blocksLayout);
        }
        if (cellLayout.getChildCount() > 0) {
            cellLayout.removeAllViews();
        }
        cellLayout.addView((View)blocksLayout, 0);
        this.setUpRowFocusRules(this.itemView, conversationPart, bubble);
        return blocksLayout;
    }

    private void setUpRowFocusRules(View row, Part conversationPart, ExpandableLayout bubble) {
        if (bubble == null) {
            return;
        }
        bubble.setAlpha(1.0f);
        if (Part.MessageState.FAILED == conversationPart.getMessageState() || Part.MessageState.UPLOAD_FAILED == conversationPart.getMessageState()) {
            ((ViewGroup)row).setDescendantFocusability(393216);
        }
    }

    protected void checkForEntranceAnimation(int type, Part part, ImageView networkAvatar, LinearLayout cellLayout, ViewGroup blocks) {
        if (part.hasEntranceAnimation()) {
            if (type == 5) {
                part.setEntranceAnimation(false);
                networkAvatar.setAlpha(0.0f);
                networkAvatar.setScaleX(0.5f);
                networkAvatar.setScaleY(0.5f);
                networkAvatar.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).setDuration(300L).setStartDelay(100L).start();
                cellLayout.setAlpha(0.0f);
                cellLayout.setScaleX(0.5f);
                cellLayout.setScaleY(0.5f);
                cellLayout.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).setDuration(300L).setStartDelay(150L).start();
                ((AdminIsTypingView)blocks.getChildAt(0)).beginAnimation();
            } else if (Part.MessageState.SENDING == part.getMessageState()) {
                part.setEntranceAnimation(false);
                cellLayout.setAlpha(0.0f);
                cellLayout.setTranslationY(cellLayout.getTranslationY() + 100.0f);
                cellLayout.animate().setStartDelay(100L).alpha(1.0f).translationYBy(-100.0f).start();
            }
        }
    }

    protected void showAvatar(Participant user, ImageView networkAvatar) {
        networkAvatar.setVisibility(0);
        AvatarUtils.createAvatar(user.getAvatar(), networkAvatar, this.itemView.getContext());
    }

    public boolean onLongClick(View v) {
        if (this.clipboardManager == null) {
            return false;
        }
        try {
            Part part = this.conversationListener.getPart(this.getAdapterPosition());
            ClipData clip = ClipData.newPlainText((CharSequence)"message", (CharSequence)part.getSummary());
            this.clipboardManager.setPrimaryClip(clip);
            Toast.makeText((Context)this.itemView.getContext(), (CharSequence)this.clipboardMessage, (int)0).show();
        }
        catch (Exception e) {
            IntercomLogger.internal(e.getMessage());
            return false;
        }
        return true;
    }
}

