/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.text.Html;
import android.view.View;
import android.view.ViewGroup;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.VideoProvider;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.blocks.models.Link;
import io.intercom.android.sdk.blocks.models.NotificationChannelsCard;
import java.util.Locale;

public enum BlockType {
    PARAGRAPH{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getParagraph().addParagraph(Html.fromHtml((String)block.getText()), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    HEADING{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getHeading().addHeading(Html.fromHtml((String)block.getText()), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    SUBHEADING{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getSubheading().addSubheading(Html.fromHtml((String)block.getText()), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    CODE{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getCode().addCode(Html.fromHtml((String)block.getText()), isFirstObject, isLastObject, layout);
        }
    }
    ,
    LINK{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLink().addLinkBlock(Link.fromBlock(block), isFirstObject, isLastObject, layout);
        }
    }
    ,
    NOTIFICATIONCHANNELSCARD{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getNotificationChannelsCard().addNotificationChannelsCardBlock(NotificationChannelsCard.fromBlock(block), isFirstObject, isLastObject, layout);
        }
    }
    ,
    UNORDEREDLIST{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getUnorderedList().addUnorderedList(block.getItems(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    ORDEREDLIST{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getOrderedList().addOrderedList(block.getItems(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    ATTACHMENTLIST{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getAttachmentList().addAttachmentList(block.getAttachments(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    IMAGE{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getImage().addImage(block.getUrl(), 10.getUrl(block), block.getWidth(), block.getHeight(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    LWR{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLwr().addLWR(block.getText(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    BUTTON{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getButton().addButton(block.getText(), 12.getUrl(block), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    FACEBOOKLIKEBUTTON{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getFacebookButton().addFacebookButton(block.getUrl(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    TWITTERFOLLOWBUTTON{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getTwitterButton().addTwitterButton("http://twitter.com/" + block.getUsername(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    VIDEO{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getVideo().addVideo(block.getEmbedUrl(), VideoProvider.videoValueOf(block.getProvider()), block.getId(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    LOCALIMAGE{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLocalImage().addImage(block.getUrl(), block.getWidth(), block.getHeight(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    LOCAL_ATTACHMENT{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLocalAttachment().addAttachment(block.getAttachments().get(0), isFirstObject, isLastObject, layout);
        }
    }
    ,
    UNKNOWN{

        @Override
        public View generateView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            if (!block.getText().isEmpty()) {
                return PARAGRAPH.generateView(viewHolder, block, layout, isFirstObject, isLastObject);
            }
            return null;
        }
    };


    public abstract View generateView(BlocksViewHolder var1, Block var2, ViewGroup var3, boolean var4, boolean var5);

    protected static String getUrl(Block block) {
        return block.getTrackingUrl().isEmpty() ? block.getLinkUrl() : block.getTrackingUrl();
    }

    public static BlockType typeValueOf(String type) {
        BlockType blockType = UNKNOWN;
        try {
            blockType = BlockType.valueOf(type.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return blockType;
    }
}

