/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.LinkBlock;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.HtmlCompat;
import io.intercom.android.sdk.utilities.Phrase;

class Link
implements LinkBlock {
    private final Context context;
    private final StyleType style;
    private final AppConfig.Provider appConfigProvider;

    Link(Context context, StyleType style, AppConfig.Provider appConfigProvider) {
        this.context = context;
        this.style = style;
        this.appConfigProvider = appConfigProvider;
    }

    public View addLinkBlock(io.intercom.android.sdk.blocks.models.Link link, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        if (this.isOnlyPart(isFirstObject, isLastObject) && this.shouldDisplayLink()) {
            return this.createLinkBlock(link, parent);
        }
        int baseColor = this.appConfigProvider.getAppConfig().getBaseColor();
        ParagraphView textView = new ParagraphView(this.context, StyleType.ADMIN, BlockAlignment.LEFT, baseColor);
        textView.setText((CharSequence)HtmlCompat.fromHtml(link.getText()));
        return textView;
    }

    private boolean shouldDisplayLink() {
        return StyleType.ADMIN.equals((Object)this.style) || StyleType.CHAT_FULL.equals((Object)this.style);
    }

    private boolean isOnlyPart(boolean isFirstObject, boolean isLastObject) {
        return isFirstObject && isLastObject;
    }

    private View createLinkBlock(io.intercom.android.sdk.blocks.models.Link link, ViewGroup parent) {
        int baseColor = this.appConfigProvider.getAppConfig().getBaseColor();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
        LinearLayout rootLayout = (LinearLayout)layoutInflater.inflate(R.layout.intercom_link_block, parent, false);
        TextView title = (TextView)rootLayout.findViewById(R.id.title);
        title.setTextColor(baseColor);
        title.setText((CharSequence)link.getTitle());
        this.setUpDescription(link, (TextView)rootLayout.findViewById(R.id.description));
        ImageView avatar = (ImageView)rootLayout.findViewById(R.id.avatar);
        TextView authorTextView = (TextView)rootLayout.findViewById(R.id.author);
        String authorName = link.getAuthor().getFirstName();
        if (TextUtils.isEmpty((CharSequence)authorName)) {
            avatar.setVisibility(8);
            authorTextView.setVisibility(8);
        } else {
            this.addAuthorDetails(link, avatar, authorTextView, authorName);
        }
        return rootLayout;
    }

    private void setUpDescription(io.intercom.android.sdk.blocks.models.Link link, TextView description) {
        String descriptionText = link.getDescription();
        if (TextUtils.isEmpty((CharSequence)descriptionText)) {
            description.setVisibility(8);
        } else {
            description.setVisibility(0);
            description.setText((CharSequence)descriptionText);
        }
    }

    private void addAuthorDetails(io.intercom.android.sdk.blocks.models.Link link, ImageView avatar, TextView authorTextView, String authorName) {
        avatar.setVisibility(0);
        authorTextView.setVisibility(0);
        SpannableString firstNameSpannable = new SpannableString((CharSequence)authorName);
        firstNameSpannable.setSpan((Object)new StyleSpan(1), 0, authorName.length(), 33);
        CharSequence writtenBy = Phrase.from(this.context, R.string.intercom_link_written_by).put("author", (CharSequence)firstNameSpannable).format();
        authorTextView.setText(writtenBy);
        int avatarSize = this.context.getResources().getDimensionPixelSize(R.dimen.intercom_avatar_size);
        Avatar authorAvatar = new Avatar.Builder().withImageUrl(link.getAuthor().getAvatar()).build();
        AvatarUtils.createAvatar(authorAvatar, avatar, avatarSize);
    }
}

