/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ScrollView;

public class ContentAwareScrollView
extends ScrollView {
    private Listener listener;

    public ContentAwareScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public ContentAwareScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ContentAwareScrollView(Context context) {
        super(context);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.notifyListenerIfAtBottom();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.notifyListenerIfAtBottom();
    }

    private boolean isAtBottom() {
        int contentBottom = this.getChildAt(0).getBottom();
        if (contentBottom == 0) {
            return false;
        }
        int visibleContentBottom = this.getBottom() + this.getScrollY();
        return visibleContentBottom >= contentBottom;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
        this.notifyListenerIfAtBottom();
    }

    protected void notifyListenerIfAtBottom() {
        if (this.listener != null && this.isAtBottom()) {
            this.listener.onBottomReached();
        }
    }

    public static interface Listener {
        public void onBottomReached();
    }
}

