/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.support.annotation.NonNull;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.retrofit2.Call;
import io.intercom.retrofit2.Callback;
import io.intercom.retrofit2.Response;

public abstract class BaseCallback<T>
implements Callback<T> {
    abstract void onSuccess(T var1);

    void onError(ErrorObject errorDetails) {
    }

    void logFailure(String reason, ErrorObject error) {
        IntercomLogger.e(reason + ": " + BaseCallback.getDetails(error));
    }

    public final void onResponse(Call<T> call, Response<T> response) {
        if (response == null || response.body() == null) {
            this.onFailure(call, new IllegalStateException("No body returned from the server"));
        } else if (!response.isSuccessful()) {
            ErrorObject error = new ErrorObject(new Exception("Status code outside the 200-300 range"), response);
            this.handleError(error);
        } else {
            this.onSuccess(response.body());
        }
    }

    public final void onFailure(Call<T> call, Throwable throwable) {
        ErrorObject error = new ErrorObject(throwable, null);
        this.handleError(error);
    }

    private void handleError(ErrorObject error) {
        this.logFailure("Api call failed", error);
        this.onError(error);
    }

    static String getDetails(@NonNull ErrorObject error) {
        String reason = error.hasErrorBody() ? error.getErrorBody() : error.getThrowable().getMessage();
        if (reason == null) {
            reason = "unknown error";
        }
        return reason;
    }
}

