/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.decoration;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.models.Part;
import java.util.List;

public class ConversationItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int SPACING = 24;
    private static final int DIVIDER_TOP_SPACING = 16;
    private static final int DIVIDER_BOTTOM_SPACING = 10;
    private static final int CONCAT_SPACING = 4;
    private final List<Part> parts;
    private final int spacing;
    private final int concatSpacing;
    private final int headerTopSpacing;
    private final int headerBottomSpacing;

    public ConversationItemDecoration(Context context, List<Part> parts) {
        this.parts = parts;
        this.spacing = ScreenUtils.convertDpToPixel((float)24.0f, (Context)context);
        this.concatSpacing = ScreenUtils.convertDpToPixel((float)4.0f, (Context)context);
        this.headerTopSpacing = ScreenUtils.convertDpToPixel((float)16.0f, (Context)context);
        this.headerBottomSpacing = ScreenUtils.convertDpToPixel((float)10.0f, (Context)context);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        int position = recyclerView.getChildLayoutPosition(view);
        if (position != -1 && position < this.parts.size()) {
            Part currentPart = this.parts.get(position);
            if ("day_divider_style".equals(currentPart.getMessageStyle())) {
                outRect.set(0, this.headerTopSpacing, 0, this.headerBottomSpacing);
            } else if (this.shouldConcatenate(currentPart, position)) {
                outRect.set(0, this.topSpacingForPartAtPosition(position), 0, this.concatSpacing);
            } else if (this.nextPartIsDivider(position)) {
                outRect.set(0, this.topSpacingForPartAtPosition(position), 0, 0);
            } else {
                outRect.set(0, this.topSpacingForPartAtPosition(position), 0, this.spacing);
            }
        }
    }

    private int topSpacingForPartAtPosition(int position) {
        return position == 0 ? this.spacing : 0;
    }

    @VisibleForTesting
    boolean shouldConcatenate(Part conversationPart, int position) {
        if (position + 1 < this.parts.size()) {
            Part nextPart = this.parts.get(position + 1);
            return Part.shouldConcatenate(conversationPart, nextPart);
        }
        return false;
    }

    private boolean nextPartIsDivider(int position) {
        return position + 1 < this.parts.size() && "day_divider_style".equals(this.parts.get(position + 1).getMessageStyle());
    }
}

