/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.app.Application;
import android.content.Context;
import android.support.v4.content.ContextCompat;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.nexus.NexusConfig;

public class Config {
    private final String name;
    private final String baseColor;
    private final boolean metricsEnabled;
    private final boolean audioEnabled;
    private final boolean isFirstRequest;
    private final boolean inboundMessages;
    private final boolean showPoweredBy;
    private final int userUpdateCacheMaxAge;
    private final NexusConfig realTimeConfig;
    private final String messageResponse;
    private final int rateLimitPeriod;
    private final int rateLimitCount;
    private final String messengerBackground;
    private final String welcomeMessage;
    private final String locale;

    public Config() {
        this(new Builder());
    }

    public Config(Builder builder) {
        this.name = builder.name == null ? "" : builder.name;
        this.isFirstRequest = builder.is_first_request;
        this.inboundMessages = builder.inbound_messages;
        this.showPoweredBy = builder.show_powered_by;
        this.baseColor = builder.base_color == null ? this.getDefaultColour() : builder.base_color;
        this.userUpdateCacheMaxAge = builder.user_update_dup_cache_max_age;
        this.realTimeConfig = builder.real_time_config == null ? new NexusConfig() : builder.real_time_config.build();
        this.messageResponse = builder.auto_response == null ? "" : builder.auto_response;
        this.rateLimitPeriod = builder.local_rate_limit_period;
        this.rateLimitCount = builder.local_rate_limit;
        this.welcomeMessage = builder.welcome_message_plain_text == null ? "" : builder.welcome_message_plain_text;
        this.messengerBackground = builder.messenger_background == null ? "" : builder.messenger_background;
        this.locale = builder.locale == null ? "" : builder.locale;
        this.audioEnabled = builder.audio_enabled == null ? true : builder.audio_enabled;
        this.metricsEnabled = builder.metrics_enabled == null ? true : builder.metrics_enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseColor() {
        return this.baseColor;
    }

    public boolean isFirstRequest() {
        return this.isFirstRequest;
    }

    public boolean isInboundMessages() {
        return this.inboundMessages;
    }

    public boolean isShowPoweredBy() {
        return this.showPoweredBy;
    }

    public int getUserUpdateCacheMaxAge() {
        return this.userUpdateCacheMaxAge;
    }

    public NexusConfig getRealTimeConfig() {
        return this.realTimeConfig;
    }

    public String getMessageResponse() {
        return this.messageResponse;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    public int getRateLimitPeriod() {
        return this.rateLimitPeriod;
    }

    public int getRateLimitCount() {
        return this.rateLimitCount;
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public String getMessengerBackground() {
        return this.messengerBackground;
    }

    public String getLocale() {
        return this.locale;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        if (this.isFirstRequest != config.isFirstRequest) {
            return false;
        }
        if (this.inboundMessages != config.inboundMessages) {
            return false;
        }
        if (this.showPoweredBy != config.showPoweredBy) {
            return false;
        }
        if (this.metricsEnabled != config.metricsEnabled) {
            return false;
        }
        if (this.userUpdateCacheMaxAge != config.userUpdateCacheMaxAge) {
            return false;
        }
        if (this.audioEnabled != config.audioEnabled) {
            return false;
        }
        if (this.rateLimitPeriod != config.rateLimitPeriod) {
            return false;
        }
        if (this.rateLimitCount != config.rateLimitCount) {
            return false;
        }
        if (!this.name.equals(config.name)) {
            return false;
        }
        if (!this.baseColor.equals(config.baseColor)) {
            return false;
        }
        if (!this.realTimeConfig.equals((Object)config.realTimeConfig)) {
            return false;
        }
        if (!this.messageResponse.equals(config.messageResponse)) {
            return false;
        }
        if (!this.messengerBackground.equals(config.messengerBackground)) {
            return false;
        }
        if (!this.welcomeMessage.equals(config.welcomeMessage)) {
            return false;
        }
        return this.locale.equals(config.locale);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.baseColor.hashCode();
        result = 31 * result + (this.isFirstRequest ? 1 : 0);
        result = 31 * result + (this.inboundMessages ? 1 : 0);
        result = 31 * result + (this.showPoweredBy ? 1 : 0);
        result = 31 * result + (this.metricsEnabled ? 1 : 0);
        result = 31 * result + this.userUpdateCacheMaxAge;
        result = 31 * result + this.realTimeConfig.hashCode();
        result = 31 * result + this.messageResponse.hashCode();
        result = 31 * result + (this.audioEnabled ? 1 : 0);
        result = 31 * result + this.rateLimitPeriod;
        result = 31 * result + this.rateLimitCount;
        result = 31 * result + this.messengerBackground.hashCode();
        result = 31 * result + this.welcomeMessage.hashCode();
        result = 31 * result + this.locale.hashCode();
        return result;
    }

    private String getDefaultColour() {
        Application context = Injector.get().getApplication();
        return String.format("#%06X", 0xFFFFFF & ContextCompat.getColor((Context)context, (int)R.color.intercom_main_blue));
    }

    public static final class Builder {
        private String name;
        private String base_color;
        private Boolean metrics_enabled;
        private Boolean audio_enabled;
        private boolean is_first_request;
        private boolean inbound_messages;
        private boolean show_powered_by;
        private int user_update_dup_cache_max_age;
        private NexusConfig.Builder real_time_config;
        private String auto_response;
        private int local_rate_limit_period;
        private int local_rate_limit;
        private String messenger_background;
        private String welcome_message_plain_text;
        private String locale;

        public Config build() {
            return new Config(this);
        }
    }
}

