/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.facebook.rebound;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.Choreographer;

public class ChoreographerCompat {
    private static final long ONE_FRAME_MILLIS = 17L;
    private static final boolean IS_JELLYBEAN_OR_HIGHER = Build.VERSION.SDK_INT >= 16;
    private static ChoreographerCompat __instance = new ChoreographerCompat();
    private Handler mHandler;
    private Choreographer mChoreographer;

    public static ChoreographerCompat getInstance() {
        return __instance;
    }

    private ChoreographerCompat() {
        if (IS_JELLYBEAN_OR_HIGHER) {
            this.mChoreographer = this.getChoreographer();
        } else {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
    }

    public void postFrameCallback(FrameCallback callbackWrapper) {
        if (IS_JELLYBEAN_OR_HIGHER) {
            this.choreographerPostFrameCallback(callbackWrapper.getFrameCallback());
        } else {
            this.mHandler.postDelayed(callbackWrapper.getRunnable(), 0L);
        }
    }

    public void postFrameCallbackDelayed(FrameCallback callbackWrapper, long delayMillis) {
        if (IS_JELLYBEAN_OR_HIGHER) {
            this.choreographerPostFrameCallbackDelayed(callbackWrapper.getFrameCallback(), delayMillis);
        } else {
            this.mHandler.postDelayed(callbackWrapper.getRunnable(), delayMillis + 17L);
        }
    }

    public void removeFrameCallback(FrameCallback callbackWrapper) {
        if (IS_JELLYBEAN_OR_HIGHER) {
            this.choreographerRemoveFrameCallback(callbackWrapper.getFrameCallback());
        } else {
            this.mHandler.removeCallbacks(callbackWrapper.getRunnable());
        }
    }

    @TargetApi(value=16)
    private Choreographer getChoreographer() {
        return Choreographer.getInstance();
    }

    @TargetApi(value=16)
    private void choreographerPostFrameCallback(Choreographer.FrameCallback frameCallback) {
        this.mChoreographer.postFrameCallback(frameCallback);
    }

    @TargetApi(value=16)
    private void choreographerPostFrameCallbackDelayed(Choreographer.FrameCallback frameCallback, long delayMillis) {
        this.mChoreographer.postFrameCallbackDelayed(frameCallback, delayMillis);
    }

    @TargetApi(value=16)
    private void choreographerRemoveFrameCallback(Choreographer.FrameCallback frameCallback) {
        this.mChoreographer.removeFrameCallback(frameCallback);
    }

    public static abstract class FrameCallback {
        private Runnable mRunnable;
        private Choreographer.FrameCallback mFrameCallback;

        @TargetApi(value=16)
        Choreographer.FrameCallback getFrameCallback() {
            if (this.mFrameCallback == null) {
                this.mFrameCallback = new Choreographer.FrameCallback(){

                    public void doFrame(long frameTimeNanos) {
                        FrameCallback.this.doFrame(frameTimeNanos);
                    }
                };
            }
            return this.mFrameCallback;
        }

        Runnable getRunnable() {
            if (this.mRunnable == null) {
                this.mRunnable = new Runnable(){

                    @Override
                    public void run() {
                        FrameCallback.this.doFrame(System.nanoTime());
                    }
                };
            }
            return this.mRunnable;
        }

        public abstract void doFrame(long var1);
    }
}

