/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.res.Resources;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.R;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public static String getFormattedTime(long time, Resources res) {
        if (time <= 0L) {
            return "";
        }
        Date date = new Date(time * 1000L);
        return TimeUtils.getFormattedTime(date, res);
    }

    public static String getFormattedTime(Date date, Resources res) {
        long diffInMin = TimeUtils.getDifferenceInMinutes(date);
        long diffInHours = TimeUtils.getDifferenceInHours(date);
        long diffInDays = TimeUtils.getDifferenceInDays(date);
        long diffInWeeks = diffInDays / 7L;
        long diffInYears = diffInWeeks / 52L;
        String displayDate = diffInYears > 0L ? res.getString(R.string.intercom_time_year_ago, new Object[]{diffInYears}) : (diffInWeeks > 0L ? res.getString(R.string.intercom_time_week_ago, new Object[]{diffInWeeks}) : (diffInDays > 0L ? res.getString(R.string.intercom_time_day_ago, new Object[]{diffInDays}) : (diffInHours > 0L ? res.getString(R.string.intercom_time_hour_ago, new Object[]{diffInHours}) : (diffInMin >= 1L ? res.getString(R.string.intercom_time_minute_ago, new Object[]{diffInMin}) : res.getString(R.string.intercom_time_just_now)))));
        return displayDate;
    }

    public static String getAdminActiveStatus(long time, Resources res) {
        if (time <= 0L) {
            return "";
        }
        Date date = new Date(time * 1000L);
        return TimeUtils.getAdminActiveStatus(date, res);
    }

    public static String getAdminActiveStatus(Date date, Resources res) {
        long diffInMin = TimeUtils.getDifferenceInMinutes(date);
        String displayDate = diffInMin > TimeUnit.DAYS.toMinutes(6L) ? res.getString(R.string.intercom_active_status_w_ago) : (diffInMin >= TimeUnit.HOURS.toMinutes(23L) + 31L ? res.getString(R.string.intercom_active_status_d_ago, new Object[]{1L + (diffInMin / 60L - 13L) / 24L}) : (diffInMin >= 53L ? res.getString(R.string.intercom_active_status_h_ago, new Object[]{1L + (diffInMin - 31L) / 60L}) : (diffInMin >= 38L ? res.getString(R.string.intercom_active_status_m_ago, new Object[]{45}) : (diffInMin >= 16L ? res.getString(R.string.intercom_active_status_m_ago, new Object[]{30}) : res.getString(R.string.intercom_active_status_15m_ago)))));
        return displayDate;
    }

    public static String getAbsoluteDate(long timeInSeconds) {
        return TimeUtils.getAbsoluteDate(timeInSeconds, Calendar.getInstance());
    }

    @VisibleForTesting
    static String getAbsoluteDate(long timeInSeconds, Calendar calendar) {
        calendar.setTimeInMillis(timeInSeconds * 1000L);
        return String.format("%s %d", calendar.getDisplayName(2, 2, Locale.getDefault()), calendar.get(5));
    }

    public static String getAbsoluteTime(long timeInSeconds) {
        return TimeUtils.getAbsoluteTime(timeInSeconds, Calendar.getInstance());
    }

    @VisibleForTesting
    static String getAbsoluteTime(long time, Calendar calendar) {
        calendar.setTimeInMillis(time * 1000L);
        return String.format(Locale.getDefault(), "%02d:%02d", calendar.get(11), calendar.get(12));
    }

    private static long getDifferenceInMinutes(Date date) {
        return TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - date.getTime());
    }

    private static long getDifferenceInHours(Date date) {
        return TimeUnit.MILLISECONDS.toHours(System.currentTimeMillis() - date.getTime());
    }

    private static long getDifferenceInDays(Date date) {
        return TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() - date.getTime());
    }
}

