/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.okhttp3.MediaType;
import io.intercom.okhttp3.RequestBody;
import io.intercom.okhttp3.internal.Util;
import io.intercom.okio.BufferedSink;
import io.intercom.okio.Okio;
import io.intercom.okio.Source;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class ProgressRequestBody
extends RequestBody {
    private static final int SEGMENT_SIZE = 2048;
    private final MediaType contentType;
    private final File file;
    private final UploadProgressListener listener;

    public ProgressRequestBody(MediaType contentType, File file, UploadProgressListener listener) {
        this.contentType = contentType;
        this.file = file;
        this.listener = listener;
    }

    public long contentLength() {
        return this.file.length();
    }

    public MediaType contentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            long read;
            source = Okio.source((File)this.file);
            long total = 0L;
            while ((read = source.read(sink.buffer(), 2048L)) != -1L) {
                sink.flush();
                this.listener.uploadNotice((byte)((double)((total += read) * 100L / this.file.length()) * 0.8 + 10.0));
            }
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }
}

