/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.identity.IdentityStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DeDuper {
    private final Map<String, Object> userUpdateAttributes = new HashMap<String, Object>();
    private final IdentityStore identityStore;
    private long earliestUpdateAt = 0L;

    public DeDuper(IdentityStore identityStore) {
        this.identityStore = identityStore;
    }

    public void setAttributes(Map<String, ?> newAttributes) {
        this.userUpdateAttributes.clear();
        this.userUpdateAttributes.putAll(newAttributes);
        this.earliestUpdateAt = this.hasExpiredCache() ? System.currentTimeMillis() : this.earliestUpdateAt;
    }

    public boolean shouldUpdateUser(Map<String, ?> newAttributes) {
        return !this.isDuplicateUpdate(newAttributes) || this.hasExpiredCache();
    }

    public void reset() {
        this.userUpdateAttributes.clear();
        this.earliestUpdateAt = 0L;
    }

    private boolean hasExpiredCache() {
        long cacheExpiryMillis = TimeUnit.SECONDS.toMillis(this.identityStore.getAppConfig().getUserUpdateCacheMaxAge());
        return System.currentTimeMillis() - this.earliestUpdateAt > cacheExpiryMillis;
    }

    private boolean isDuplicateUpdate(Map<String, ?> newAttributes) {
        HashMap<String, Object> allAttributes = new HashMap<String, Object>();
        allAttributes.putAll(this.userUpdateAttributes);
        allAttributes.putAll(newAttributes);
        return allAttributes.equals(this.userUpdateAttributes);
    }

    @VisibleForTesting
    Map<String, Object> getMap() {
        return this.userUpdateAttributes;
    }

    @VisibleForTesting
    void setEarliestUpdateAt(long time) {
        this.earliestUpdateAt = time;
    }

    @VisibleForTesting
    long getEarliestUpdateAt() {
        return this.earliestUpdateAt;
    }
}

