/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.fragments;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.fragments.IntercomSupportFragment;
import io.intercom.android.sdk.utilities.FontUtils;

public class MaterialDialog
extends IntercomSupportFragment
implements View.OnClickListener {
    private static final String REQUEST_CODE = "request_code";
    private static final String TITLE = "title";
    private static final String MESSAGE = "message";
    private static final String PRIMARY_BUTTON_TEXT = "primary_button_text";
    private static final String SECONDARY_BUTTON_TEXT = "secondary_button_text";
    private int requestCode;
    @Nullable
    private Callback callback;

    public static MaterialDialog getInstance(int requestCode, @StringRes int titleRes, @StringRes int messageRes, @StringRes int primaryButtonText, @StringRes int secondaryButtonText) {
        MaterialDialog materialDialog = new MaterialDialog();
        Bundle arguments = new Bundle();
        arguments.putInt(REQUEST_CODE, requestCode);
        arguments.putInt(TITLE, titleRes);
        arguments.putInt(MESSAGE, messageRes);
        arguments.putInt(PRIMARY_BUTTON_TEXT, primaryButtonText);
        arguments.putInt(SECONDARY_BUTTON_TEXT, secondaryButtonText);
        materialDialog.setArguments(arguments);
        return materialDialog;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle arguments = this.getArguments();
        this.requestCode = arguments.getInt(REQUEST_CODE);
    }

    @Override
    public void onSupportAttach(Context context) {
        super.onSupportAttach(context);
        this.callback = context instanceof Callback ? (Callback)context : null;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup parent, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.intercom_material_dialog, parent, false);
        Bundle arguments = this.getArguments();
        TextView title = (TextView)view.findViewById(R.id.intercom_dialog_title);
        title.setText(arguments.getInt(TITLE));
        FontUtils.setTypeface((Context)this.getActivity(), title, "intercom_roboto_medium.ttf");
        ((TextView)view.findViewById(R.id.intercom_dialog_message)).setText(arguments.getInt(MESSAGE));
        TextView primaryButton = (TextView)view.findViewById(R.id.intercom_primary_button);
        primaryButton.setTextColor(Injector.get().getIdentityStore().getAppConfig().getBaseColor());
        primaryButton.setOnClickListener((View.OnClickListener)this);
        primaryButton.setText(arguments.getInt(PRIMARY_BUTTON_TEXT));
        FontUtils.setTypeface((Context)this.getActivity(), primaryButton, "intercom_roboto_medium.ttf");
        TextView secondaryButton = (TextView)view.findViewById(R.id.intercom_secondary_button);
        secondaryButton.setTextColor(Injector.get().getIdentityStore().getAppConfig().getBaseColor());
        int secondaryText = arguments.getInt(SECONDARY_BUTTON_TEXT);
        if (secondaryText != 0) {
            secondaryButton.setText(secondaryText);
            FontUtils.setTypeface((Context)this.getActivity(), secondaryButton, "intercom_roboto_medium.ttf");
            secondaryButton.setOnClickListener((View.OnClickListener)this);
        } else {
            secondaryButton.setVisibility(4);
        }
        return view;
    }

    public void onClick(View v) {
        this.dismiss();
        if (this.callback == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.intercom_primary_button) {
            this.callback.onPrimaryButtonClicked(this.requestCode);
        } else if (id2 == R.id.intercom_secondary_button) {
            this.callback.onSecondaryButtonClicked(this.requestCode);
        }
    }

    public static interface Callback {
        public void onPrimaryButtonClicked(int var1);

        public void onSecondaryButtonClicked(int var1);
    }
}

