/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ScrollView;
import io.intercom.android.sdk.R;

public class LockableScrollView
extends ScrollView {
    private boolean scrollable = true;
    private int maxHeight = 0;
    private boolean isExpanded = true;
    private boolean interceptTouch = false;

    public LockableScrollView(Context context) {
        super(context);
    }

    public LockableScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setUp(attrs);
    }

    public LockableScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setUp(attrs);
    }

    public void setUp(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.LockableScrollView);
        this.maxHeight = a.getDimensionPixelSize(R.styleable.LockableScrollView_intercomHeightLimit, 0);
        this.isExpanded = a.getBoolean(R.styleable.LockableScrollView_intercomExpanded, true);
        this.interceptTouch = a.getBoolean(R.styleable.LockableScrollView_intercomInterceptTouch, true);
        a.recycle();
    }

    public void setScrollingEnabled(boolean enabled) {
        this.scrollable = enabled;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int newHeightMeasureSpec = heightMeasureSpec;
        if (!this.isExpanded) {
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            switch (heightSpecMode) {
                case -2147483648: 
                case 0x40000000: {
                    int limitedHeight = Math.min(View.MeasureSpec.getSize((int)heightMeasureSpec), this.maxHeight);
                    newHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)limitedHeight, (int)heightSpecMode);
                    break;
                }
                default: {
                    newHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxHeight, (int)Integer.MIN_VALUE);
                }
            }
        }
        super.onMeasure(widthMeasureSpec, newHeightMeasureSpec);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        return this.scrollable && super.onTouchEvent(ev);
    }

    public void scrollTo(int x, int y) {
        if (this.scrollable) {
            super.scrollTo(x, y);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.interceptTouch;
    }

    public void toggleExpanded() {
        this.setExpanded(!this.isExpanded);
    }

    public void setExpanded(boolean expanded) {
        if (expanded != this.isExpanded) {
            this.isExpanded = expanded;
            this.requestLayout();
            this.invalidate();
        }
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }
}

