/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.TimeFormatterExtKt;
import io.intercom.android.sdk.utilities.commons.ScreenUtils;

abstract class InAppNotification
implements View.OnTouchListener {
    protected static final int BASE_MARGIN_DP = 16;
    private static final float RESISTANCE = 2.0f;
    private static final int ANIMATE_OFFSCREEN_OFFSET = 200;
    private static final int DISMISS_DISTANCE_DP = 80;
    protected static final float SCALE_OFFSET = 0.05f;
    protected static final int MARGIN_OFFSET_DP = 8;
    final Listener listener;
    protected final int screenHeight;
    protected final Context localisedContext;
    protected final Provider<AppConfig> appConfigProvider;
    protected Conversation conversation;
    protected int position;
    private float initialViewX;
    private float initialTouchX;
    protected ViewGroup overlayRoot;
    protected int bottomPadding = 0;

    protected InAppNotification(Context localisedContext, Conversation conversation, int position, int screenHeight, Listener listener2, Provider<AppConfig> appConfigProvider) {
        this.conversation = conversation;
        this.listener = listener2;
        this.position = position;
        this.screenHeight = screenHeight;
        this.localisedContext = localisedContext;
        this.appConfigProvider = appConfigProvider;
    }

    protected int calculateBottomMargin(int position, int bottomPadding, Context context) {
        Resources resources = context.getResources();
        int margin = ScreenUtils.dpToPx(16 + 8 * position, context);
        return margin + resources.getDimensionPixelSize(R.dimen.intercom_bottom_padding) + bottomPadding;
    }

    public void removeView() {
        View rootView = this.getRootView();
        if (rootView != null && rootView.getParent() != null) {
            ((ViewGroup)rootView.getParent()).removeView(rootView);
        }
    }

    public Conversation getConversation() {
        return this.conversation;
    }

    public boolean onTouch(View v, MotionEvent event) {
        float dx = (event.getRawX() - this.initialTouchX) / 2.0f;
        switch (event.getAction()) {
            case 0: {
                this.initialViewX = v.getX();
                this.initialTouchX = event.getRawX();
                this.onNotificationPressed(this.getRootView());
                break;
            }
            case 2: {
                v.setX(dx + this.initialViewX);
                break;
            }
            case 1: {
                float absDx = Math.abs(dx);
                if (absDx < 5.0f) {
                    this.listener.onInAppNotificationTap(this.conversation);
                    break;
                }
                if (absDx > (float)ScreenUtils.dpToPx(80.0f, this.localisedContext)) {
                    this.stopListeningForTouchEvents();
                    this.animateOffScreen(v);
                    break;
                }
                this.onNotificationReleased(this.getRootView());
                this.animateToOriginalPosition(v);
                break;
            }
        }
        return true;
    }

    private void animateToOriginalPosition(View view) {
        view.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).translationX(0.0f).setDuration(300L).start();
    }

    private void animateOffScreen(View view) {
        int offset = ScreenUtils.dpToPx(200.0f, view.getContext());
        float endValue = view.getX() > this.initialViewX ? (float)(this.getParentOrScreenWidth(view) + offset) : (float)(-1 * view.getWidth() - offset);
        view.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).translationX(endValue).setDuration(300L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                InAppNotification.this.listener.onInAppNotificationDismiss(InAppNotification.this);
            }
        }).start();
    }

    private int getParentOrScreenWidth(View view) {
        ViewParent parent = view.getParent();
        if (parent instanceof View) {
            return ((View)parent).getWidth();
        }
        return view.getResources().getDisplayMetrics().widthPixels;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isAttached() {
        return this.overlayRoot.getParent() != null;
    }

    protected CharSequence getHeaderText() {
        Part lastPart = this.conversation.lastPart();
        if (this.conversation.getParticipants().size() > 1) {
            return Phrase.from(this.localisedContext, R.string.intercom_reply_from_admin).putOptional("name", lastPart.getParticipant().getForename()).format();
        }
        if (this.conversation.parts().isEmpty()) {
            return lastPart.getParticipant().getForename();
        }
        return lastPart.getParticipant().getForename() + " \u2022 " + TimeFormatterExtKt.formattedDateFromLong(lastPart.getCreatedAt(), this.localisedContext);
    }

    public void updateBottomPadding(Context context, int bottomPadding) {
        if (this.bottomPadding != bottomPadding && this.overlayRoot != null) {
            this.bottomPadding = bottomPadding;
            int targetBottomMargin = this.calculateBottomMargin(this.position, bottomPadding, context);
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.overlayRoot.getLayoutParams();
            ValueAnimator va = ValueAnimator.ofInt((int[])new int[]{params.bottomMargin, targetBottomMargin});
            int mDuration = 300;
            va.setDuration((long)mDuration);
            va.addUpdateListener(animation -> {
                params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, ((Integer)animation.getAnimatedValue()).intValue());
                this.overlayRoot.setLayoutParams((ViewGroup.LayoutParams)params);
            });
            va.start();
        }
    }

    protected void animateToPosition(Context context) {
        int targetBottomMargin = this.calculateBottomMargin(this.position, this.bottomPadding, context);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.overlayRoot.getLayoutParams();
        float startScaleX = this.overlayRoot.getScaleX();
        float endScaleX = 1.0f - (float)this.position * 0.05f;
        ValueAnimator marginAnimator = ValueAnimator.ofInt((int[])new int[]{params.bottomMargin, targetBottomMargin});
        marginAnimator.setDuration(200L);
        marginAnimator.addUpdateListener(animation -> {
            params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, ((Integer)animation.getAnimatedValue()).intValue());
            this.overlayRoot.setLayoutParams((ViewGroup.LayoutParams)params);
        });
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{startScaleX, endScaleX});
        ObjectAnimator scaleAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)this.overlayRoot, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX});
        scaleAnimator.setDuration(200L);
        marginAnimator.start();
        scaleAnimator.start();
    }

    protected void animateToBackOfStack(Context context) {
        Resources resources = context.getResources();
        int rootHeight = (int)resources.getDimension(R.dimen.intercom_notification_preview_height);
        int bottomMargin = this.calculateBottomMargin(this.position, this.bottomPadding, context);
        int dy = this.screenHeight - (rootHeight + bottomMargin);
        int ddy = dy + ScreenUtils.dpToPx(8.0f, context);
        PropertyValuesHolder y = PropertyValuesHolder.ofFloat((Property)View.Y, (float[])new float[]{ddy, dy});
        PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{this.overlayRoot.getAlpha(), 1.0f});
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.85f, 1.0f - (float)this.position * 0.05f});
        ObjectAnimator.ofPropertyValuesHolder((Object)this.overlayRoot, (PropertyValuesHolder[])new PropertyValuesHolder[]{y, alpha, scaleX}).setDuration(200L).start();
    }

    protected void performReplyPulse(View textContainer, final View text, final Runnable updateEndAction) {
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f, 1.05f});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f, 1.05f});
        ObjectAnimator textBubbleAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)textContainer, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY}).setDuration(150L);
        textBubbleAnimator.setRepeatCount(1);
        textBubbleAnimator.setRepeatMode(2);
        textBubbleAnimator.start();
        ObjectAnimator fadeOutAnimator = ObjectAnimator.ofFloat((Object)text, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(200L);
        fadeOutAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                InAppNotification.this.updateViewDataDuringReplyPulse(InAppNotification.this.bottomPadding);
                ObjectAnimator fadeInAnimator = ObjectAnimator.ofFloat((Object)text, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}).setDuration(200L);
                fadeInAnimator.setStartDelay(100L);
                fadeInAnimator.start();
                fadeInAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        updateEndAction.run();
                    }
                });
            }
        });
        fadeOutAnimator.start();
    }

    public void moveForward(ViewGroup root, LayoutInflater inflater) {
        --this.position;
        if (this.position <= 0) {
            this.animateToPosition(root.getContext());
            this.beginListeningForTouchEvents();
        } else if (this.position == 1) {
            this.animateToPosition(root.getContext());
        } else if (this.position == 2) {
            this.display(root, inflater, false, this.bottomPadding);
            this.animateToBackOfStack(root.getContext());
        }
    }

    protected void stopListeningForTouchEvents() {
        this.overlayRoot.setOnTouchListener(null);
    }

    protected void beginListeningForTouchEvents() {
        this.overlayRoot.setOnTouchListener((View.OnTouchListener)this);
    }

    protected View getRootView() {
        return this.overlayRoot;
    }

    protected abstract void onNotificationPressed(View var1);

    protected abstract void onNotificationReleased(View var1);

    public void display(ViewGroup root, Conversation conversation, LayoutInflater inflater, boolean withFullAnimation, int bottomPadding) {
        this.conversation = conversation;
        this.display(root, inflater, withFullAnimation, bottomPadding);
    }

    public abstract void display(ViewGroup var1, LayoutInflater var2, boolean var3, int var4);

    public abstract void update(Conversation var1, Runnable var2);

    protected abstract void updateViewDataDuringReplyPulse(int var1);

    public void moveBackward(ViewGroup rootView) {
        this.moveBackward(rootView, new AnimatorListenerAdapter(){});
    }

    public abstract void moveBackward(ViewGroup var1, AnimatorListenerAdapter var2);

    static interface Listener {
        public void onInAppNotificationTap(Conversation var1);

        public void onInAppNotificationDismiss(InAppNotification var1);
    }
}

